/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.property.AbstractCSSValue;

/**
 * Factory for style declarations.
 * 
 * @author Carlos Amengual
 *
 */
public class StyleDeclarationFactory {

	public StyleDeclarationFactory() {
		super();
	}

	/**
	 * Creates a CSSStyleDeclaration.
	 * 
	 * @return a new CSSStyleDeclaration.
	 */
	public static CSSStyleDeclaration createCSSStyleDeclaration() {
		return new BaseCSSStyleDeclaration();
	}

	/**
	 * Parses a property value.
	 * 
	 * @param value the string containing the property value
	 * @return the CSSValue object containing the parsed value.
	 * @throws DOMException
	 */
	public static CSSValue parseProperty(String value)
	throws DOMException {
		Parser parser;
		try {
			parser = SACParserFactory.createSACParser();
		} catch (DOMException e) {
			// Could not create parser.
			throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, e
					.getMessage());
		}
		InputSource source = new InputSource();
		Reader re = new StringReader(value);
		source.setCharacterStream(re);
		LexicalUnit lunit = null;
		try {
			lunit = parser.parsePropertyValue(source);
		} catch (CSSException e) {
			throw new DOMException(DOMException.SYNTAX_ERR, e
					.getMessage());
		} catch (IOException e) {
			// This should never happen!
			throw new DOMException(DOMException.INVALID_STATE_ERR, e
					.getMessage());
		}
		return AbstractCSSValue.createCSSValue(lunit);
	}

}
