/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

/**
 * Abstract class to be inherited by CSS rules which have a CSSStyleDeclaration.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
abstract class CSSStyleDeclarationRule extends BaseCSSRule {

	private CSSStyleDeclaration declaration = null;

	private SelectorList selectorList = null;

	private String selectorText = null;

	protected CSSStyleDeclarationRule(CSSStyleSheet parentSheet, short type) {
		super(parentSheet, type);
		declaration = new BaseCSSStyleDeclaration(this);
	}

	public CSSStyleDeclaration getStyle() {
		return declaration;
	}

	public String getSelectorText() {
		return selectorText;
	}

	public void setSelectorText(String selectorText) throws DOMException {
		this.selectorText = selectorText;
	}

	void setSelectorList(SelectorList selectorList) {
		this.selectorList = selectorList;
		int sz = selectorList.getLength();
		StringBuilder sb = new StringBuilder(sz * 5 + 2);
		if (sz > 0) {
			sb.append(selectorList.item(0));
			for (int i = 1; i < sz; i++) {
				sb.append(',').append(selectorList.item(i));
			}
		}
		setSelectorText(sb.toString());
	}

	SelectorList getSelectorList() {
		return selectorList;
	}

	public void setCssText(String cssText) throws DOMException {
		CSSStyleDeclaration styledecl = new BaseCSSStyleDeclaration(this);
		styledecl.setCssText(cssText);
	}

	public String getCssText() {
		return getSelectorText() + ' ' + '{' + getStyle().getCssText() + '}';
	}
}
