/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Style declaration for DOM.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOMCSSStyleDeclaration extends ComputedCSSStyle {

	private DOMCSSStyleSheet parentSheet = null;

	public DOMCSSStyleDeclaration() {
		super();
	}

	public DOMCSSStyleDeclaration(DOMCSSStyleSheet parentSheet) {
		super();
		this.parentSheet = parentSheet;
	}

	public DOMCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
		super(copiedObject);
	}

	public String getPeerXPath() {
		// TODO: JRE does not include default support for XPath.
		return "";
	}

	public String getParentXPath() {
		// TODO: JRE does not include default support for XPath.
		return "";
	}

	public DOMCSSStyleDeclaration getParentComputedStyle() {
		DOMCSSStyleDeclaration parentCss = null;
		Node node = getPeerNode();
		if (node != null) {
			Element parent = (Element) node.getParentNode();
			if (parent != null && parentSheet != null) {
				parentCss = (DOMCSSStyleDeclaration) parentSheet.getComputedStyle(
						parent, null);
				if (parentCss != null) {
					parentCss.setStyleDatabase(getStyleDatabase());
				}
			}
		}
		return parentCss;
	}

	/**
	 * Gets the (whitespace-trimmed) text content of the 
	 * node associated to this style.
	 * 
	 * @return the text content, or the empty string if the box 
	 * has no text.
	 */
	@Override
	public String getText() {
		String text = getPeerNode().getTextContent().trim().replace("  ", " ");
		// TODO: compress white spaces
		return text;
	}

	@Override
	public DOMCSSStyleDeclaration clone() {
		DOMCSSStyleDeclaration styleClone = new DOMCSSStyleDeclaration(this);
		styleClone.setPeerNode(getPeerNode());
		styleClone.setStyleDatabase(getStyleDatabase());
		return styleClone;
	}
}
