/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.j2d;

import info.informatica.doc.dom4j.DocumentFormatter;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSStyleException;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.box.RunInBox;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Java2DRenderer {

	private CSSContainerBox rootBox;

	public Java2DRenderer() {
		super();
	}

	public void setDocument(XHTMLDocument xdoc) throws CSSStyleException {
		rootBox = new DocumentFormatter(new Java2DUserAgent()).formatDocument(xdoc);
	}

	public void paint(Graphics2D g2) {
		drawStaticBlockBox(g2, rootBox, 0, 0);
	}

	protected void drawStaticBlockBox(Graphics2D g2, CSSContainerBox box, 
			float x, float initialY) {
		x += box.getLeft();
		configureGraphics(g2, box);
		g2.draw(new Rectangle2D.Double(x, initialY, box.getWidth(), box.getHeight()));
		System.err.println("y=" + initialY);
		CSSBoxContainer container = box.asContainerBox();
		x += box.getMarginLeft();
		float y = initialY + box.getMarginTop();
		if(container instanceof CSSBlockBoxContainer){
			List<CSSContainerBox> blockBoxes = ((CSSBlockBoxContainer)container)
				.getStaticallyPositioned();
			Iterator<CSSContainerBox> it = blockBoxes.iterator();
			while(it.hasNext()){
				CSSContainerBox bbox = it.next();
				drawStaticBlockBox(g2, bbox, x, y);
				y += bbox.getHeight();
			}
		} else if(container instanceof CSSInlineBoxContainer) {
			List<CSSBox> inBoxes = ((CSSInlineBoxContainer)container).getInlineBoxes();
			Iterator<CSSBox> it = inBoxes.iterator();
			while(it.hasNext()){
				CSSBox b = it.next();
				CSSInlineBox inBox;
				if(b instanceof CSSInlineBox) {
					inBox = (CSSInlineBox) b;
				} else {
					// Must be a run-in box
					b = ((RunInBox)b).finalBox();
					if(b instanceof CSSInlineBox) {
						inBox = (CSSInlineBox) b;
					} else {
						// FIXME
						continue;
					}
				}
				x += drawInlineBox(g2, inBox, x, y);
			}
			//y += ((CSSInlineBoxContainer)container).computeHeight(((CSSInlineBoxContainer)container).getContentWidth());
		}
	}

	protected float drawInlineBox(Graphics2D g2, CSSInlineBox box, float x, float y) {
		x += box.getMarginLeft();
		y += box.getMarginTop();
		g2.setFont(createFont(box.getComputedStyle()));
		String text = box.getText();
		g2.drawString(text, x, y);
		return box.textLengthToNaturalUnit(text.length());
	}

	public static Font createFont(CSS2ComputedProperties styledecl) {
		String fontfamily = styledecl.getFontFamily();
		int sz = styledecl.getFontSize();
		// Font style
		String stylename = styledecl.getPropertyValue("font-style");
		int style = Font.PLAIN;
		if (stylename.length() > 0) {
			stylename = stylename.toLowerCase();
			if (stylename.equals("italic")) {
				style = Font.ITALIC;
			}
		}
		String fontweight = styledecl.getFontWeight();
		if (fontweight != null) {
			fontweight = fontweight.toLowerCase();
			if (fontweight.equals("bold")) {
				if (style != Font.ITALIC) {
					style = Font.BOLD;
				} else {
					style = Font.ITALIC & Font.BOLD;
				}
			}
		}
		Map<TextAttribute, Object>textAttrs = new HashMap<TextAttribute, Object>();
		String decoration = styledecl.getPropertyValue("text-decoration");
		if (decoration.length() > 0) {
			decoration = decoration.toLowerCase();
			if (decoration.equals("underline")) {
				textAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
			} else if (decoration.equals("line-through")) {
				textAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
			}
		}
		//
		Font font = new Font(fontfamily, style, sz);
		return font.deriveFont(textAttrs);
	}

	public static void configureGraphics(Graphics2D g2, CSSContainerBox box) {
		g2.setColor(Java2DStyleDatabase.getAWTColor(
				box.getComputedStyle().getColor()));
		g2.setBackground(Java2DStyleDatabase.getAWTColor(
				box.getComputedStyle().getBackgroundColor()));
	}

	public float getWidth() {
		return rootBox.getWidth();
	}

	public float getHeight() {
		return rootBox.getHeight();
	}

}
