/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

/**
 * Percentage CSSPrimitiveValue.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class CSSPercentageValue extends CSSNumberValue {

	CSSPercentageValue() {
		super();
	}

    /**
     *  Gets a float value in a specified unit. If this 
     * CSS value doesn't contain a float value or can't be converted into 
     * the specified unit, a <code>DOMException</code> is raised. 
     * @param unitType A unit code to get the float value. The unit code can 
     *   only be a float unit type (i.e. <code>CSS_NUMBER</code>, 
     *   <code>CSS_PERCENTAGE</code>, <code>CSS_EMS</code>, 
     *   <code>CSS_EXS</code>, <code>CSS_PX</code>, <code>CSS_CM</code>, 
     *   <code>CSS_MM</code>, <code>CSS_IN</code>, <code>CSS_PT</code>, 
     *   <code>CSS_PC</code>, <code>CSS_DEG</code>, <code>CSS_RAD</code>, 
     *   <code>CSS_GRAD</code>, <code>CSS_MS</code>, <code>CSS_S</code>, 
     *   <code>CSS_HZ</code>, <code>CSS_KHZ</code>, 
     *   <code>CSS_DIMENSION</code>). 
     * @return  The float value in the specified unit. 
     * @throws DOMException
     *   INVALID_ACCESS_ERR if the CSS value doesn't contain a float 
     *   value or if the float value can't be converted into the specified 
     *   unit. 
     */
	@Override
	public float getFloatValue(short unitType) throws DOMException {
		if(unitType == getPrimitiveType() || unitType == CSSPrimitiveValue.CSS_NUMBER){
			return realvalue;
		} else {
			throw new DOMException(DOMException.INVALID_ACCESS_ERR, 
					"Cannot convert a percentage at this level");
		}
	}

}
