/*

 Copyright (c) 2005-2008, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

/**
 * Value for a shorthand property.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class CSSShorthandValue implements CSSValue {

	private String cssText = null;

	public CSSShorthandValue() {
		super();
	}

	public String getCssText() {
		return cssText;
	}

	public void setCssText(String cssText) throws DOMException {
		throw new DOMException(DOMException.NO_MODIFICATION_ALLOWED_ERR, 
			"This property can only be changed from CSSStyleDeclaration.setCssText()");
	}
	
	public void setShorthandText(String cssText) throws DOMException {
		this.cssText = cssText;
	}

	public short getCssValueType() {
		return CSSValue.CSS_CUSTOM;
	}
	
}
