/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

/**
 * String-specific CSSPrimitiveValue.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class CSSStringValue extends AbstractCSSPrimitiveValue {
	
	private String stringValue = null;

	public CSSStringValue() {
		super();
	}

	@Override
	public String getStringValue() throws DOMException {
		return stringValue;
	}

	@Override
	public void setStringValue(short stringType, String stringValue) throws DOMException {
		setCSSUnitType(stringType);
		setStringValue(stringValue);
	}

	protected void setStringValue(String stringValue) {
		this.stringValue = stringValue;
	}

	@Override
	void setLexicalUnit(LexicalUnit lunit) {
		super.setLexicalUnit(lunit);
		setStringValue(lunit.getStringValue());
		if(stringValue.indexOf(' ') > 0) {
			stringValue = '"' + stringValue + '"';
		}
		LexicalUnit nexLu = lunit.getNextLexicalUnit();
		while(nexLu != null && nexLu.getLexicalUnitType() == LexicalUnit.SAC_OPERATOR_COMMA) {
			nexLu = nexLu.getNextLexicalUnit();
			String nextValue = nexLu.getStringValue();
			if(nextValue.indexOf(' ') > 0) {
				stringValue += ", \"" + nextValue + '"';
			} else {
				stringValue += ", " + nextValue;
			}
			nexLu = nexLu.getNextLexicalUnit();
		}
		setCssText(stringValue);
	}
	
	@Override
	public String toString() {
		return stringValue;
	}

}
