/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.property;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

/**
 * Implementation of CSSValueList.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class DOMCSSValueList extends AbstractCSSValue implements CSSValueList {

	private List<CSSValue> valueList;

	public DOMCSSValueList() {
		super(CSSValue.CSS_VALUE_LIST);
		valueList = new ArrayList<CSSValue>();
	}

	public int getLength() {
		return valueList.size();
	}

	public CSSValue item(int index) {
		return valueList.get(index);
	}
	
	public void add(CSSValue value) {
		valueList.add(value);
	}
}
