/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual;

import info.informatica.doc.style.css.property.CSSPropertyException;

import org.w3c.dom.css.CSSValue;

/**
 * CSS inline box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSInlineBox extends CSSBox {

	/**
	 * Gets the text content of this box.
	 * 
	 * @return the text content, or the empty string if the box 
	 * has no text.
	 */
	public String getText();

	/**
	 * Gets the 'used' value for the font-family property.
	 * <p>This method requires a style database.</p>
	 * 
	 * @return the value of the font-family property.
	 * @throws IllegalStateException if the style database has not been set.
	 */
	public String getFontFamily();

	/**
	 * Gets the computed font weight.
	 * 
	 * @return the font weight.
	 */
	public String getFontWeight();

	/**
	 * Gets the computed value of the font-size property.
	 * <p>May require a style database to work.</p>
	 * 
	 * @return the value of the font-size property, in typographic points.
	 */
	public int getFontSize();

	public float getLineHeight() throws CSSPropertyException;

	public float getLineHeight(float defval)
			throws CSSPropertyException;

	public float getLeading();

	public float getLeading(float defval);

	public CSSValue getLineHeightCSSValue();

	public float getContentWidth();
	
	public float getMinimumWidth();
	
	public float computeHeight(float width);

	public float textLengthToNaturalUnit(int length);

}
