/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual;

import info.informatica.doc.agent.UserAgent;


/**
 * To be implemented by replaced element boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface ReplacedElementBox<C> extends CSSBox {

	/**
	 * Initializes the replaced element.
	 * <p>
	 * Must be called before using any of the other methods.
	 * @param agent the user agent.
	 * 
	 * @throws CSSReplacementException if an error occurred when 
	 * initializing the replaced element box.
	 */
	public void init(UserAgent<C> agent) throws CSSReplacementException;

	/**
	 * Gets the width of this box, expressed in the 
	 * unit given by the <code>StyleDatabase.getNaturalUnit()</code> method.
	 * 
	 * @return the width of this box.
	 */
	public float getWidth();

	/**
	 * Gets the height of this box.
	 * 
	 * @return the height.
	 */
	public float getHeight();
	
	/**
	 * Gets the intrinsic width of this box, as obtained from the 
	 * replaced element.
	 * 
	 * @return the width.
	 */
	public float getIntrinsicWidth();

	/**
	 * Gets the intrinsic height of this box, as obtained from the 
	 * replaced element.
	 * 
	 * @return the intrinsic height.
	 */
	public float getIntrinsicHeight();

}