/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;

import java.util.ArrayList;
import java.util.List;

/**
 * Container of CSS block boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class BlockContainer implements CSSBlockBoxContainer {
	
	// Descendants that are positioned according to normal flow
	private List<CSSContainerBox> statically;

	// Absolutely positioned descendants
	private List<CSSContainerBox> absolutely = 
		new ArrayList<CSSContainerBox>();

	public BlockContainer() {
		super();
		statically = new ArrayList<CSSContainerBox>();
	}

	public BlockContainer(int size) {
		super();
		statically = new ArrayList<CSSContainerBox>(size);
	}

	public List<CSSContainerBox> getStaticallyPositioned() {
		return statically;
	}

	public List<CSSContainerBox> getStaticallyPositionedList() {
		return statically;
	}

	public List<CSSContainerBox> getAbsolutelyPositioned() {
		return absolutely;
	}

	public void addAbsolutelyPositioned(AbsolutelyPositionedBox absolutelyPositioned) {
		absolutely.add(absolutelyPositioned);
	}

	public float getContentWidth() {
		float width = 0;
		for(int i=0; i<statically.size(); i++){
			float boxWidth = statically.get(i).getWidth();
			if(boxWidth > width) {
				width = boxWidth;
			}
		}
		return width;
	}

	public float getMinimumWidth() {
		float width = Float.POSITIVE_INFINITY;
		for(int i=0; i<statically.size(); i++){
			float boxWidth = statically.get(i).getWidth();
			if(boxWidth < width) {
				width = boxWidth;
			}
		}
		return width;
	}

	public float computeAutoHeight() {
		float height = 0;
		/*
		 * FIXME
		 * This is a simple temporary model, but need to account for
		 * this:
		 * "However, if the element has a non-zero top padding and/or 
		 * top border, or is the root element, then the content starts 
		 * at the top margin edge of the topmost child. (The first case 
		 * expresses the fact that the top and bottom margins of the 
		 * element collapse with those of the topmost and bottommost 
		 * children, while in the second case the presence of the 
		 * padding/border prevents the top margins from collapsing.) 
		 * Similarly, if the element has a non-zero bottom padding 
		 * and/or bottom border, then the content ends at the bottom 
		 * margin edge of the bottommost child."
		 */
		for(int i=0; i<statically.size(); i++){
			CSSContainerBox box = statically.get(i);
			height += box.getHeight();
		}
		return height;
	}

}
