/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.structure.TableRenderer;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSTableCellBox;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * CSS table cell.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class TableCellBox extends BlockBox implements CSSTableCellBox {

	private int rowIndex;

	public TableCellBox(CSS2ComputedProperties style) {
		super(style);
	}

	public Node getNode() {
		return getComputedStyle().getPeerNode();
	}

	public void setRowIndex(int rowIndex) {
		this.rowIndex = rowIndex;
	}

	public int getRowIndex() {
		return rowIndex;
	}

	public int columnSpan() {
		String s = ((Element) getNode()).getAttribute("colspan");
		if (s == null) {
			return 1;
		} else {
			try {
				return Integer.parseInt(s);
			} catch(NumberFormatException e) {
				getErrorHandler().error("Could not parse column span: " + s);
				return 1;
			}
		}
	}

	public int rowSpan() {
		String s = ((Element) getNode()).getAttribute("rowspan");
		if (s == null) {
			return 1;
		} else {
			try {
				return Integer.parseInt(s);
			} catch(NumberFormatException e) {
				getErrorHandler().error("Could not parse row span: " + s);
				return 1;
			}
		}
	}

	public void print(TableRenderer tablePrinter) {
		tablePrinter.printCell(this, getNode().getTextContent());
	}

}
