/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.CSSTableRowBox;

import java.util.Iterator;
import java.util.LinkedList;

/**
 * CSS table row box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class TableRowBox extends AbstractCSSBox implements CSSTableRowBox {

	private LinkedList<TableCellBox> columns = new LinkedList<TableCellBox>();

	private int columnCount = 0;

	public TableRowBox(CSS2ComputedProperties style) {
		super(style);
	}

	public void add(TableCellBox cell) {
		int colspan = cell.columnSpan();
		if (colspan < 1) {
			getErrorHandler().error("colspan less than 1");
			colspan = 1;
		}
		columnCount += colspan;
		cell.setRowIndex(columns.size());
		columns.add(cell);
	}

	public Iterator<TableCellBox> iterator() {
		return columns.iterator();
	}

	public CSSTableCellBox[] getCells() {
		return columns.toArray(new CSSTableCellBox[0]);
	}

	public TableCellBox getLast() {
		return columns.getLast();
	}

	public boolean isEmpty() {
		return columns.isEmpty();
	}

	public int getColumnCount() {
		return columnCount;
	}

	@Override
	protected float getWidth() {
		return getContentWidth();
	}

	public float getContentWidth() {
		float width = 0;
		Iterator<TableCellBox> cellit = columns.iterator();
		while(cellit.hasNext()) {
			TableCellBox cell = cellit.next();
			width += cell.getWidth();
		}
		return width;
	}

	@Override
	protected float getHeight() {
		// FIXME: this is a possible source of infinite loop.
		return computeAutoHeight(getContainerWidth());
	}

	public float computeAutoHeight(float containerWidth) {
		float height = 0;
		Iterator<TableCellBox> cellit = columns.iterator();
		while(cellit.hasNext()) {
			TableCellBox cell = cellit.next();
			float cellHeight = cell.computeAutoHeight(containerWidth);
			if(cellHeight > height) {
				height = cellHeight;
			}
		}
		return height;
	}

}
