/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.CSSTableRowBox;
import info.informatica.doc.style.css.visual.container.CSSTableRowContainer;

import java.util.ArrayList;
import java.util.List;


/**
 * A container that contains table-row boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class TableRowContainer implements CSSTableRowContainer {

	private List<CSSTableRowBox> rows = new ArrayList<CSSTableRowBox>();
	
	public TableRowContainer() {
		super();
	}

	/**
	 * Gets the table rows.
	 * 
	 * @return an array with the table rows.
	 */
	public List<CSSTableRowBox> getRows() {
		return rows;
	}

	public float getContentWidth() {
		float width = 0;
		for(int i=0; i<rows.size(); i++){
			float boxWidth = rows.get(i).getContentWidth();
			if(boxWidth > width) {
				width = boxWidth;
			}
		}
		return width;
	}

	public float getMinimumWidth() {
		float width = Float.POSITIVE_INFINITY;
		for(int i=0; i<rows.size(); i++){
			float boxWidth = rows.get(i).getContentWidth();
			if(boxWidth < width) {
				width = boxWidth;
			}
		}
		return width;
	}

	public float computeAutoHeight(float containerWidth) {
		float height = 0;
		for(int i=0; i<rows.size(); i++){
			CSSTableRowBox row = rows.get(i);
			height += row.computeAutoHeight(containerWidth);
		}
		return height;
	}


}