/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public abstract class CSSStyleSheetFactory {
    private ClassLoader classLoader = null;
    public static final String XHTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    static Logger log = Logger.getLogger((String)CSSStyleSheetFactory.class.getName());

    public CSSStyleSheet createStyleSheet() {
        DOMMediaList mediaList = new DOMMediaList();
        return this.createStyleSheet(XHTML_NAMESPACE_URI, mediaList);
    }

    public CSSStyleSheet createStyleSheet(String namespaceUri, String media) {
        if (media == null) {
            throw new NullPointerException("Null media list");
        }
        return this.createStyleSheet(namespaceUri, new DOMMediaList(media));
    }

    public abstract CSSStyleSheet createStyleSheet(String var1, MediaList var2);

    public static void parse(CSSStyleSheet sheet, InputSource source) throws DOMException, IOException {
        ((BaseCSSStyleSheet)sheet).parseCSSStyleSheet(source);
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    InputStream readXHTMLDefaultSheet() {
        return this.loadCSSfromClasspath("html.css");
    }

    public CSSStyleSheet loadXHTMLDefaultSheet() throws IOException {
        BaseCSSStyleSheet cssSheet;
        Reader re = null;
        try {
            re = new InputStreamReader(this.loadCSSfromClasspath("html.css"));
            InputSource source = new InputSource(re);
            cssSheet = (BaseCSSStyleSheet)this.createStyleSheet();
            cssSheet.parseCSSStyleSheet(source);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                re.close();
            }
            catch (IOException e) {}
        }
        return cssSheet;
    }

    protected InputStream loadCSSfromClasspath(final String cssFilename) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (CSSStyleSheetFactory.this.classLoader != null) {
                    return CSSStyleSheetFactory.this.classLoader.getResourceAsStream(CSSStyleSheetFactory.resourcePath(CSSStyleSheetFactory.class.getPackage().getName(), cssFilename));
                }
                return this.getClass().getResourceAsStream(cssFilename);
            }
        });
    }

    private static String resourcePath(String clase, String filename) {
        return '/' + clase.replace('.', '/') + '/' + filename;
    }
}

