/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

abstract class CSSStyleDeclarationRule
extends BaseCSSRule {
    private CSSStyleDeclaration declaration = new BaseCSSStyleDeclaration(this);
    private SelectorList selectorList = null;
    private String selectorText = null;

    protected CSSStyleDeclarationRule(CSSStyleSheet parentSheet, short type) {
        super(parentSheet, type);
    }

    public CSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    public void setSelectorText(String selectorText) throws DOMException {
        this.selectorText = selectorText;
    }

    void setSelectorList(SelectorList selectorList) {
        this.selectorList = selectorList;
        int sz = selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 5 + 2);
        if (sz > 0) {
            sb.append(selectorList.item(0));
            for (int i = 1; i < sz; ++i) {
                sb.append(',').append(selectorList.item(i));
            }
        }
        this.setSelectorText(sb.toString());
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        BaseCSSStyleDeclaration styledecl = new BaseCSSStyleDeclaration(this);
        styledecl.setCssText(cssText);
    }

    @Override
    public String getCssText() {
        return this.getSelectorText() + ' ' + '{' + this.getStyle().getCssText() + '}';
    }
}

