/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.CSSInheritedValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

public class AbstractCSSValue
implements CSSValue {
    private final short valueType;
    private String cssText = null;

    protected AbstractCSSValue(short valueType) {
        this.valueType = valueType;
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.cssText = cssText;
    }

    @Override
    public short getCssValueType() {
        return this.valueType;
    }

    public static CSSValue createCSSValue(LexicalUnit lunit) {
        return AbstractCSSValue.createCSSValue(lunit, false);
    }

    public static CSSValue createCSSValue(LexicalUnit lunit, boolean subproperty) {
        short unitType = lunit.getLexicalUnitType();
        CSSValue value = null;
        switch (unitType) {
            case 12: {
                value = CSSInheritedValue.getValue();
                break;
            }
            default: {
                value = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lunit);
                ((AbstractCSSPrimitiveValue)value).setSubproperty(subproperty);
            }
        }
        return value;
    }
}

