/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.structure.TableRenderer;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.box.BlockBox;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableCellBox
extends BlockBox
implements CSSTableCellBox {
    private int rowIndex;

    public TableCellBox(CSS2ComputedProperties style) {
        super(style);
    }

    public Node getNode() {
        return this.getComputedStyle().getPeerNode();
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int columnSpan() {
        String s = ((Element)this.getNode()).getAttribute("colspan");
        if (s == null) {
            return 1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.getErrorHandler().error("Could not parse column span: " + s);
            return 1;
        }
    }

    @Override
    public int rowSpan() {
        String s = ((Element)this.getNode()).getAttribute("rowspan");
        if (s == null) {
            return 1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.getErrorHandler().error("Could not parse row span: " + s);
            return 1;
        }
    }

    public void print(TableRenderer tablePrinter) {
        tablePrinter.printCell(this, this.getNode().getTextContent());
    }
}

