/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class OriginPolicy {
    private static final List<String> TOP_LEVEL_SUFFIX = new ArrayList<String>();
    private static final List<String> SUFFIX_EXCEPTIONS = new ArrayList<String>();
    private static final List<String> SUFFIX_WILDCARDS = new ArrayList<String>();
    private static OriginPolicy singleton = new OriginPolicy();

    static {
        OriginPolicy.readSuffixes();
    }

    private OriginPolicy() {
    }

    private static void readSuffixes() {
        BufferedReader re = null;
        try {
            re = new BufferedReader(new InputStreamReader(OriginPolicy.openStream("/info/informatica/doc/agent/effective_tld_names.dat"), "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String line = null;
        try {
            try {
                while ((line = re.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                    if (line.charAt(0) == '*') {
                        SUFFIX_WILDCARDS.add(line.substring(2));
                        continue;
                    }
                    if (line.charAt(0) == '!') {
                        SUFFIX_EXCEPTIONS.add(line.substring(1));
                        continue;
                    }
                    TOP_LEVEL_SUFFIX.add(line);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                re.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static InputStream openStream(final String fileName) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return OriginPolicy.class.getResourceAsStream(fileName);
            }
        });
    }

    public static OriginPolicy getInstance() {
        return singleton;
    }

    public boolean isTopLevelSuffix(String possibleTld) {
        if (TOP_LEVEL_SUFFIX.contains(possibleTld) || SUFFIX_WILDCARDS.contains(possibleTld)) {
            return true;
        }
        int idx = possibleTld.indexOf(46);
        return idx > 0 && SUFFIX_WILDCARDS.contains(possibleTld.substring(idx + 1)) && !SUFFIX_EXCEPTIONS.contains(possibleTld);
    }

    public String domainFromHostname(String host) {
        String domain = host;
        int count = host.length();
        int idx = count - 1;
        while (idx >= 0) {
            String possibleTld;
            if (domain.charAt(idx) == '.' && !this.isTopLevelSuffix(possibleTld = domain.subSequence(idx + 1, count).toString())) {
                return possibleTld;
            }
            --idx;
        }
        return host;
    }
}

