/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.XHTMLDocumentFactory;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.DocumentCSSStyleSheet;
import info.informatica.doc.style.css.dom.SelectorMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSStylableElement
extends DOMElement
implements CSSElement {
    private static final long serialVersionUID = 3L;
    private SelectorMatcher selectorMatcher = null;
    private Map<String, DOM4JCSSStyleDeclaration> overrideStyleSet = null;

    public CSSStylableElement(String name) {
        super(name);
    }

    public CSSStylableElement(QName qname) {
        super(qname);
    }

    public CSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public CSSDocument getOwnerDocument() {
        return (CSSDocument)super.getDocument();
    }

    public String getId() {
        String id = this.attributeValue("id");
        return id != null ? id : "";
    }

    protected String elementID(Element element) {
        return element.attributeValue("id");
    }

    protected String inlineStyle() {
        return this.attributeValue("style");
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        DOM4JCSSStyleDeclaration styledecl = new DOM4JCSSStyleDeclaration();
        styledecl.setPeerNode(this);
        String st = this.inlineStyle();
        if (st != null && st.length() > 0) {
            try {
                styledecl.setCssText(st);
            }
            catch (DOMException e) {
                ((XHTMLDocumentFactory)this.getDocumentFactory()).getCSSStyleSheetFactory().getErrorHandler().onException((Exception)e, st);
            }
        }
        return styledecl;
    }

    CSSStyleDeclaration getOverrideStyle(String pseudoElt) {
        DOM4JCSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<String, DOM4JCSSStyleDeclaration>();
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = new DOM4JCSSStyleDeclaration();
            overrideStyle.setPeerNode(this);
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    public CSSStyleDeclaration getComputedStyle(String pseudoElt) {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            DOM4JCSSStyleDeclaration styledecl = (DOM4JCSSStyleDeclaration)css.getComputedStyle(this, pseudoElt);
            return styledecl;
        }
        return null;
    }

    public CSSStyleDeclaration getComputedStyle() {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            CSSStyleDeclaration styledecl = css.getComputedStyle(this, null);
            return styledecl;
        }
        return null;
    }

    public SelectorMatcher getSelectorMatcher() {
        if (this.selectorMatcher == null) {
            this.selectorMatcher = new DOM4JSelectorMatcher();
        }
        return this.selectorMatcher;
    }

    class DOM4JSelectorMatcher
    extends SelectorMatcher {
        private String idAttr = null;

        DOM4JSelectorMatcher() {
            this.setTagname(CSSStylableElement.this.getName().intern());
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                this.setParentTagname(parent.getName().intern());
            }
            this.setClassAttribute(CSSStylableElement.this.attributeValue("class"));
            this.idAttr = CSSStylableElement.this.getId();
        }

        @Override
        public SelectorMatcher getParentSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent instanceof CSSStylableElement) {
                return ((CSSStylableElement)parent).getSelectorMatcher();
            }
            return null;
        }

        @Override
        public SelectorMatcher getPreviousSiblingSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return null;
            }
            List elements = parent.elements();
            Object sibling = elements.get(elements.indexOf(CSSStylableElement.this) - 1);
            if (sibling instanceof CSSStylableElement) {
                return ((CSSStylableElement)sibling).getSelectorMatcher();
            }
            return null;
        }

        @Override
        public boolean isFirstChild() {
            return CSSStylableElement.this.getParent().indexOf((Node)CSSStylableElement.this) == 0;
        }

        @Override
        public String getAttributeValue(String attrName) {
            String value = CSSStylableElement.this.attributeValue(attrName);
            return value != null ? value : "";
        }

        @Override
        public boolean hasAttribute(String attrName) {
            return CSSStylableElement.this.attribute(attrName) != null;
        }

        @Override
        public String getId() {
            return this.idAttr;
        }

        @Override
        public String getLanguage() {
            String lang = CSSStylableElement.this.attributeValue("lang");
            while (lang == null || lang.length() == 0) {
                Element parent = CSSStylableElement.this.getParent();
                if (parent == null) break;
                lang = parent.attributeValue("lang");
            }
            if (lang == null) {
                lang = "";
            }
            return lang;
        }
    }
}

