/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.DocumentException;
import info.informatica.doc.agent.AbstractUserAgent;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.dom4j.XHTMLDocumentFactory;
import info.informatica.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.dom4j.DocumentFactory;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XPP3Reader;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xmlpull.v1.XmlPullParserException;

public class DOM4JUserAgent
extends AbstractUserAgent {
    private EntityResolver resolver = new DefaultEntityResolver();
    private boolean useXPP3;
    private XHTMLDocumentFactory factory;

    protected DOM4JUserAgent() {
        this(false);
    }

    protected DOM4JUserAgent(boolean useXPP3) {
        this.useXPP3 = useXPP3;
        this.factory = new AgentXHTMLDocumentFactory();
    }

    public static UserAgent createUserAgent(boolean useXPP3) {
        return new DOM4JUserAgent(useXPP3);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XHTMLDocument readURL(URL url) throws IOException, DocumentException {
        long time = System.currentTimeMillis();
        URLConnection con = this.openConnection(url, time);
        String conType = con.getContentType();
        InputStream is = null;
        AgentXHTMLDocumentFactory.AgentXHTMLDocument xdoc = null;
        try {
            try {
                PushbackReader re;
                int iread;
                int idx;
                is = con.getInputStream();
                String charset = null;
                if (conType == null) {
                    conType = URLConnection.guessContentTypeFromStream(is);
                }
                if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
                    charset = conType.substring(idx + 8);
                }
                if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
                    charset = "utf-8";
                } else {
                    re.unread(iread);
                }
                xdoc = this.useXPP3 ? (AgentXHTMLDocumentFactory.AgentXHTMLDocument)this.xPP3ParseDocument(re) : (AgentXHTMLDocumentFactory.AgentXHTMLDocument)this.parseDocument(re);
                xdoc.setLoadingTime(time);
                xdoc.setBaseURL(url);
            }
            catch (IOException e) {
                throw e;
            }
            catch (org.dom4j.DocumentException e) {
                throw new DocumentException("Error parsing document " + url.toExternalForm(), e);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String defStyle = con.getHeaderField("Default-Style");
        NodeList list = xdoc.getElementsByTagName("meta");
        int listL = list.getLength();
        int i = listL - 1;
        while (i >= 0) {
            String metaDefStyle;
            if ("Default-Style".equalsIgnoreCase(((DOMElement)list.item(i)).attributeValue("http-equiv")) && (metaDefStyle = ((DOMElement)list.item(i)).attributeValue("content")) != null) {
                defStyle = metaDefStyle;
            }
            --i;
        }
        if (defStyle != null) {
            xdoc.setSelectedStyleSheetSet(defStyle);
        }
        if (con instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)con;
            this.readCookies(hcon, time);
            hcon.disconnect();
        }
        return xdoc;
    }

    protected XHTMLDocument parseDocument(PushbackReader re) throws org.dom4j.DocumentException {
        InputSource isrc = new InputSource(re);
        XHTMLDocumentFactory factory = this.getXHTMLDocumentFactory();
        SAXReader reader = new SAXReader((DocumentFactory)factory);
        reader.setEntityResolver(this.resolver);
        return (XHTMLDocument)reader.read(isrc);
    }

    protected XHTMLDocument xPP3ParseDocument(PushbackReader re) throws org.dom4j.DocumentException, IOException {
        XHTMLDocumentFactory factory = this.getXHTMLDocumentFactory();
        XPP3Reader reader = new XPP3Reader((DocumentFactory)factory);
        try {
            return (XHTMLDocument)reader.read((Reader)re);
        }
        catch (XmlPullParserException e) {
            throw new org.dom4j.DocumentException((Throwable)e);
        }
    }

    public XHTMLDocumentFactory getXHTMLDocumentFactory() {
        return this.factory;
    }

    class AgentXHTMLDocumentFactory
    extends XHTMLDocumentFactory {
        private static final long serialVersionUID = 1L;

        AgentXHTMLDocumentFactory() {
        }

        @Override
        public XHTMLDocument createDocument() {
            AgentXHTMLDocument mydoc = new AgentXHTMLDocument();
            mydoc.setDocumentFactory((DocumentFactory)this);
            mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
            mydoc.setUserImportantStyleDeclaration(this.getUserImportantStyle());
            return mydoc;
        }

        class AgentXHTMLDocument
        extends XHTMLDocument {
            private static final long serialVersionUID = 1L;
            private long loadingTime;

            AgentXHTMLDocument() {
            }

            AgentXHTMLDocument(String name) {
                super(name);
            }

            AgentXHTMLDocument(DOMElement rootElement) {
                super(rootElement);
            }

            AgentXHTMLDocument(DOMDocumentType docType) {
                super(docType);
            }

            AgentXHTMLDocument(DOMElement rootElement, DOMDocumentType docType) {
                super(rootElement, docType);
            }

            AgentXHTMLDocument(String name, DOMElement rootElement, DOMDocumentType docType) {
                super(name, rootElement, docType);
            }

            @Override
            public URLConnection openConnection(URL url) throws IOException {
                return DOM4JUserAgent.this.openConnection(url, this.loadingTime);
            }

            public void setLoadingTime(long time) {
                this.loadingTime = time;
            }
        }
    }
}

