/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.agent.DeviceFactory;
import info.informatica.doc.dom4j.BaseHrefAttribute;
import info.informatica.doc.dom4j.BaseURLElement;
import info.informatica.doc.dom4j.CachedTableCellElement;
import info.informatica.doc.dom4j.CachedTableElement;
import info.informatica.doc.dom4j.CachedTableRowElement;
import info.informatica.doc.dom4j.CachedXHTMLElement;
import info.informatica.doc.dom4j.CenterElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.DOM4JDocumentCSSStyleSheet;
import info.informatica.doc.dom4j.DocumentStyleEventAttribute;
import info.informatica.doc.dom4j.FontElement;
import info.informatica.doc.dom4j.HeadElement;
import info.informatica.doc.dom4j.LinkElement;
import info.informatica.doc.dom4j.StrikeElement;
import info.informatica.doc.dom4j.StyleAttribute;
import info.informatica.doc.dom4j.StyleDefinerElement;
import info.informatica.doc.dom4j.StyleElement;
import info.informatica.doc.dom4j.TableCellElement;
import info.informatica.doc.dom4j.TableElement;
import info.informatica.doc.dom4j.TableRowElement;
import info.informatica.doc.dom4j.UnderlineElement;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.dom4j.XHTMLElement;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.ErrorHandler;
import info.informatica.doc.style.css.LogErrorHandler;
import info.informatica.doc.style.css.dom.AbstractCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DummyDeviceFactory;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocumentFactory;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleRule;

public class XHTMLDocumentFactory
extends DOMDocumentFactory {
    private static final long serialVersionUID = 6L;
    private DOM4JDocumentCSSStyleSheet defStyleSheet = null;
    private AbstractCSSStyleDeclaration userImportantStyle = null;
    private AbstractCSSStyleDeclaration userNormalStyle = null;
    private DOM4JDocumentCSSStyleSheet uaStyleSheet = null;
    private DOM4JCSSStyleSheetFactory cssFactory = new DOM4JCSSStyleSheetFactory();
    private boolean styleCacheOn = false;
    private DeviceFactory deviceFactory = new DummyDeviceFactory();
    private static transient XHTMLDocumentFactory singleton = new XHTMLDocumentFactory();

    protected XHTMLDocumentFactory() {
    }

    public static XHTMLDocumentFactory getInstance() {
        return singleton;
    }

    public DOM4JDocumentCSSStyleSheet getUserAgentStyleSheet() {
        if (this.uaStyleSheet == null) {
            try {
                this.uaStyleSheet = (DOM4JDocumentCSSStyleSheet)this.getCSSStyleSheetFactory().loadXHTMLDefaultSheet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load User Agent style sheet.", e);
            }
        }
        return this.uaStyleSheet;
    }

    protected DOM4JDocumentCSSStyleSheet getDefaultStyleSheet() {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        return this.defStyleSheet;
    }

    public DOM4JCSSStyleSheetFactory getCSSStyleSheetFactory() {
        return this.cssFactory;
    }

    public void setUserAgentStyleSheet(DOM4JDocumentCSSStyleSheet styleSheet) {
        this.uaStyleSheet = styleSheet;
        this.defStyleSheet = null;
    }

    public void setUserStyleSheet(AbstractCSSStyleSheet styleSheet) {
        if (styleSheet != null) {
            this.userImportantStyle = styleSheet.createCSSStyleDeclaration();
            this.userNormalStyle = styleSheet.createCSSStyleDeclaration();
            CSSRuleArrayList rules = styleSheet.getCssRules();
            int rl = rules.getLength();
            int i = 0;
            while (i < rl) {
                CSSRule r = rules.item(i);
                if (r.getType() == 1) {
                    AbstractCSSStyleDeclaration st = (AbstractCSSStyleDeclaration)((CSSStyleRule)r).getStyle();
                    st.prioritySplit(this.userImportantStyle, this.userNormalStyle);
                }
                ++i;
            }
        } else {
            this.userImportantStyle = null;
            this.userNormalStyle = null;
        }
    }

    protected AbstractCSSStyleDeclaration getUserImportantStyle() {
        return this.userImportantStyle;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet().clone();
        if (this.userNormalStyle != null) {
            this.defStyleSheet.addRule(this.userNormalStyle.getParentRule());
        }
    }

    public boolean isStyleCacheOn() {
        return this.styleCacheOn;
    }

    public void setStyleCache(boolean onOff) {
        this.styleCacheOn = onOff;
    }

    public Element createElement(QName qname) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname);
        }
        if ("center".equals(name)) {
            return new CenterElement(qname);
        }
        if ("u".equals(name)) {
            return new UnderlineElement(qname);
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return new StrikeElement(qname);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname);
            }
            return new CachedXHTMLElement(qname);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname);
        }
        if ("table".equals(name)) {
            return new TableElement(qname);
        }
        return new XHTMLElement(qname);
    }

    public Element createElement(QName qname, int attributeCount) {
        String name = qname.getName();
        if ("base".equals(name)) {
            return new BaseURLElement(qname, attributeCount);
        }
        if ("style".equals(name)) {
            return new StyleElement(qname, attributeCount);
        }
        if ("link".equals(name)) {
            return new LinkElement(qname, attributeCount);
        }
        if ("head".equals(name)) {
            return new HeadElement(qname, attributeCount);
        }
        if ("title".equals(name) || "meta".equals(name)) {
            return new XHTMLElement(qname, attributeCount);
        }
        if ("font".equals(name) || "basefont".equals(name)) {
            return new FontElement(qname, attributeCount);
        }
        if ("center".equals(name)) {
            return new CenterElement(qname, attributeCount);
        }
        if ("u".equals(name)) {
            return new UnderlineElement(qname, attributeCount);
        }
        if ("s".equals(name) || "strike".equals(name)) {
            return new StrikeElement(qname, attributeCount);
        }
        if (this.styleCacheOn) {
            if ("td".equals(name) || "th".equals(name)) {
                return new CachedTableCellElement(qname, attributeCount);
            }
            if ("tr".equals(name)) {
                return new CachedTableRowElement(qname, attributeCount);
            }
            if ("table".equals(name)) {
                return new CachedTableElement(qname, attributeCount);
            }
            return new CachedXHTMLElement(qname, attributeCount);
        }
        if ("td".equals(name) || "th".equals(name)) {
            return new TableCellElement(qname, attributeCount);
        }
        if ("tr".equals(name)) {
            return new TableRowElement(qname, attributeCount);
        }
        if ("table".equals(name)) {
            return new TableElement(qname, attributeCount);
        }
        return new XHTMLElement(qname, attributeCount);
    }

    public XHTMLDocument createDocument() {
        XHTMLDocument mydoc = new XHTMLDocument();
        mydoc.setDocumentFactory((DocumentFactory)this);
        mydoc.setDefaultStyleSheet(this.getDefaultStyleSheet());
        mydoc.setUserImportantStyleDeclaration(this.getUserImportantStyle());
        return mydoc;
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        if (owner instanceof StyleDefinerElement) {
            return new DocumentStyleEventAttribute(qname, value);
        }
        if (owner instanceof BaseURLElement && qname.getName().equals("href")) {
            return new BaseHrefAttribute(qname, value);
        }
        if (owner instanceof CachedXHTMLElement && qname.getName().equals("style")) {
            return new StyleAttribute(qname, value);
        }
        return super.createAttribute(owner, qname, value);
    }

    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    public static /* bridge */ /* synthetic */ DocumentFactory getInstance() {
        return XHTMLDocumentFactory.getInstance();
    }

    public class DOM4JCSSStyleSheetFactory
    extends CSSStyleSheetFactory {
        private ErrorHandler errorHandler = new LogErrorHandler();

        DOM4JCSSStyleSheetFactory() {
        }

        @Override
        public DOM4JDocumentCSSStyleSheet createDocumentStyleSheet() {
            return new DOM4JDocumentCSSStyleSheet(this);
        }

        @Override
        public DOM4JCSSStyleSheet createRuleStyleSheet(CSSRule ownerRule, String title, DOMMediaList mediaList) {
            return new DOM4JCSSStyleSheet(this, title, null, mediaList, ownerRule);
        }

        @Override
        public DOM4JCSSStyleSheet createLinkedStyleSheet(CSSElement ownerElement, String title, DOMMediaList mediaList) {
            return new DOM4JCSSStyleSheet(this, title, ownerElement, mediaList, null);
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }
    }
}

