/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractStyleDatabase
implements StyleDatabase {
    protected final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    public static final AbstractCSSPrimitiveValue DEFAULT_INITIAL_COLOR = (AbstractCSSPrimitiveValue)AbstractCSSValue.parseProperty("#000000");
    private CSSPrimitiveValue initialColor = DEFAULT_INITIAL_COLOR;
    private float scrollbarWidth = 0.0f;

    @Override
    public float getDocumentHeight() {
        return this.getDeviceHeight();
    }

    @Override
    public float getDocumentWidth() {
        return this.getDeviceWidth();
    }

    protected abstract float cmToPixels(float var1);

    protected abstract float pxTocm(int var1);

    @Override
    public int getExSizeInPt(String familyName, int size) {
        return Math.round(0.5f * (float)size);
    }

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType, short destUnitType) throws DOMException {
        if (initialUnitType == destUnitType || initialUnitType == 1) {
            return initialValue;
        }
        if (initialValue == 0.0f) {
            return 0.0f;
        }
        switch (initialUnitType) {
            case 9: {
                switch (destUnitType) {
                    case 8: {
                        return initialValue / (float)this.getPointsPerInch();
                    }
                    case 6: {
                        return initialValue / (float)this.getPointsPerInch() * 2.54f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue / (float)this.getPointsPerInch() * 2.54f);
                    }
                }
                break;
            }
            case 6: {
                switch (destUnitType) {
                    case 9: {
                        return initialValue * (float)this.getPointsPerInch() * 0.39370078f;
                    }
                    case 8: {
                        return initialValue / 2.54f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue);
                    }
                }
                break;
            }
            case 8: {
                switch (destUnitType) {
                    case 9: {
                        return initialValue * (float)this.getPointsPerInch();
                    }
                    case 6: {
                        return initialValue * 2.54f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue * 2.54f);
                    }
                }
                break;
            }
            case 5: {
                switch (destUnitType) {
                    case 9: {
                        return this.pxTocm((int)initialValue) * (float)this.getPointsPerInch() * 0.39370078f;
                    }
                    case 6: {
                        return this.pxTocm((int)initialValue);
                    }
                    case 8: {
                        return this.pxTocm((int)initialValue) / 2.54f;
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                return initialValue;
            }
        }
        throw new DOMException(15, "Unable to do unit conversion from " + initialUnitType + " to " + destUnitType);
    }

    protected abstract int getPointsPerInch();

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType) throws DOMException {
        return this.floatValueConversion(initialValue, initialUnitType, this.getNaturalUnit());
    }

    @Override
    public CSSPrimitiveValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String initialColor) {
        this.initialColor = (CSSPrimitiveValue)((Object)AbstractCSSValue.parseProperty(initialColor));
    }

    @Override
    public float getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public void setScrollbarWidth(float width) {
        this.scrollbarWidth = width;
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }
}

