/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.SheetErrorHandler;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;

public class DefaultSheetErrorHandler
implements SheetErrorHandler {
    static Logger log = LoggerFactory.getLogger((String)DefaultSheetErrorHandler.class.getName());
    private Map<CSSParseException, AbstractCSSRule> error2rule = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;

    @Override
    public void unknownRuleType(CSSRule rule) {
        log.info("While computing style, found rule of type " + rule.getType());
    }

    @Override
    public void emptyCascade(String selector) {
        if (log.isDebugEnabled()) {
            log.debug("Could not find styles matching selector " + selector);
        }
    }

    @Override
    public void ignoredImport(String uri) {
        log.debug("Ignoring @import from " + uri + ": must be at the beginning of the style sheet (CSS 2.1 \u00a74.1.5)");
    }

    @Override
    public void emptyRule(String selector) {
        if (log.isDebugEnabled()) {
            log.debug("Discarding empty Style rule for selector " + selector);
        }
    }

    @Override
    public void emptyMediaList() {
        log.warn("Found a @media rule with empty media list");
    }

    @Override
    public void inlineStyleError(DOMException e, CSSElement elm, String attr) {
        log.error("Error processing inline style: " + attr, (Throwable)e);
    }

    @Override
    public void mapError(CSSParseException exception, AbstractCSSRule rule) {
        if (this.error2rule == null) {
            this.error2rule = new HashMap<CSSParseException, AbstractCSSRule>();
        }
        this.error2rule.put(exception, rule);
    }

    @Override
    public void handleSacWarning(CSSParseException exception) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(exception);
    }

    public List<CSSParseException> getSacWarnings() {
        return this.sacWarnings;
    }

    @Override
    public void handleSacError(CSSParseException exception) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(exception);
    }

    public List<CSSParseException> getSacErrors() {
        return this.sacErrors;
    }

    @Override
    public Map<CSSParseException, AbstractCSSRule> getErrorMap() {
        return this.error2rule;
    }

    @Override
    public boolean hasSacErrors() {
        return this.error2rule != null || this.sacErrors != null;
    }

    @Override
    public boolean hasSacWarnings() {
        return this.sacWarnings != null;
    }

    @Override
    public void reset() {
        this.error2rule = null;
        this.sacErrors = null;
        this.sacWarnings = null;
    }

    public String toString() {
        Iterator<Object> it;
        StringBuilder buf = new StringBuilder(20);
        if (this.hasSacErrors()) {
            buf.append("SAC Errors:\n");
            if (this.sacErrors != null) {
                it = this.sacErrors.iterator();
                while (it.hasNext()) {
                    buf.append(' ').append(((CSSParseException)it.next()).getMessage());
                }
                buf.append('\n');
            }
            if (this.error2rule != null) {
                for (Map.Entry entry : this.error2rule.entrySet()) {
                    buf.append(' ').append(((CSSParseException)entry.getKey()).getMessage()).append(" -> ").append(((AbstractCSSRule)entry.getValue()).getCssText()).append('\n');
                }
            }
        } else {
            buf.append("No SAC errors.\n");
        }
        if (this.sacWarnings != null) {
            buf.append("SAC Warnings:");
            it = this.sacWarnings.iterator();
            while (it.hasNext()) {
                buf.append(' ').append(((CSSParseException)it.next()).getMessage());
            }
        } else {
            buf.append("No SAC warnings.\n");
        }
        return buf.toString();
    }
}

