/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.agent.AbstractDeviceFactory;
import info.informatica.doc.agent.CSSCanvas;
import info.informatica.doc.agent.Viewport;
import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.w3c.MediaQueryList;
import org.w3c.dom.DOMException;

public class DummyDeviceFactory
extends AbstractDeviceFactory {
    private StyleDatabase dummyDatabase = new DummyStyleDatabase();

    @Override
    public CSSCanvas createCanvas(String medium, CSSDocument doc) {
        return new DummyCanvas(doc);
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        return this.dummyDatabase;
    }

    class DummyCanvas
    implements CSSCanvas {
        private CSSDocument doc;

        DummyCanvas(CSSDocument doc) {
            this.doc = doc;
        }

        @Override
        public StyleDatabase getStyleDatabase() {
            return DummyDeviceFactory.this.dummyDatabase;
        }

        @Override
        public void loadFontFace(DOMCSSFontFaceRule rule) {
        }

        @Override
        public boolean isFontFaceName(String requestedFamily) {
            return false;
        }

        @Override
        public Viewport getViewport() {
            return null;
        }

        @Override
        public MediaQueryList parseMediaQueryList(String mediaQueryString) {
            return null;
        }

        @Override
        public CSSDocument getDocument() {
            return this.doc;
        }
    }

    public static class DummyStyleDatabase
    extends AbstractStyleDatabase {
        @Override
        public int getBitsPerColor() {
            return 8;
        }

        @Override
        public String getDefaultGenericFontFamily(String genericFamily) {
            String fontName = null;
            if (genericFamily.equals("serif")) {
                fontName = "Serif";
            } else if (genericFamily.equals("sans serif")) {
                fontName = "SansSerif";
            } else if (genericFamily.equals("monospace")) {
                fontName = "Monospaced";
            }
            return fontName;
        }

        @Override
        public boolean isFontFamilyAvailable(String fontFamily) {
            return true;
        }

        @Override
        public int getFontSizeFromIdentifier(String familyName, String fontSizeIdentifier) throws DOMException {
            float sz;
            if (fontSizeIdentifier.equals("xx-small")) {
                sz = 8.0f;
            } else if (fontSizeIdentifier.equals("x-small")) {
                sz = 9.0f;
            } else if (fontSizeIdentifier.equals("small")) {
                sz = 10.0f;
            } else if (fontSizeIdentifier.equals("medium")) {
                sz = 12.0f;
            } else if (fontSizeIdentifier.equals("large")) {
                sz = 14.0f;
            } else if (fontSizeIdentifier.equals("x-large")) {
                sz = 16.0f;
            } else if (fontSizeIdentifier.equals("xx-large")) {
                sz = 18.0f;
            } else {
                throw new DOMException(15, "Unknown size identifier: " + fontSizeIdentifier);
            }
            return Math.round(sz);
        }

        @Override
        public short getNaturalUnit() {
            return 5;
        }

        @Override
        public float getWidthSize(String widthIdentifier) throws DOMException {
            if ("thin".equals(widthIdentifier)) {
                return 0.5f;
            }
            if ("thick".equals(widthIdentifier)) {
                return 2.0f;
            }
            if ("medium".equals(widthIdentifier)) {
                return 1.0f;
            }
            throw new DOMException(12, "Unknown identifier " + widthIdentifier);
        }

        @Override
        public float getDeviceHeight() {
            return 768.0f;
        }

        @Override
        public float getDeviceWidth() {
            return 1024.0f;
        }

        @Override
        protected int getPointsPerInch() {
            return 72;
        }

        @Override
        protected float cmToPixels(float cm) {
            return cm * 30.0f;
        }

        @Override
        protected float pxTocm(int px) {
            return (float)px / 30.0f;
        }
    }
}

