/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSStringValue
extends AbstractCSSPrimitiveValue {
    private String stringValue = null;

    public CSSStringValue() {
    }

    protected CSSStringValue(CSSStringValue copied) {
        super(copied);
        this.stringValue = copied.stringValue;
        this.setUnescapedCssText(this.stringValue);
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.stringValue;
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (this.isSubproperty()) {
            throw new DOMException(7, "This property was set with a shorthand. Must modify at the style-declaration level.");
        }
        this.setCSSUnitType(stringType);
        this.setStringValue(stringValue);
        this.setUnescapedCssText(stringValue);
    }

    protected void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        super.setLexicalUnit(lunit, subp);
        String strval = lunit.getStringValue();
        this.setUnescapedCssText(strval);
        if (lunit.getLexicalUnitType() == 36) {
            strval = CSSStringValue.unescapeLF(strval);
        }
        this.setStringValue(strval);
        this.nextLexicalUnit = lunit.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    private void setUnescapedCssText(String css) {
        boolean hasSingleQuotes;
        boolean useDQ = true;
        boolean hasDoubleQuotes = css.indexOf(34) != -1;
        boolean bl = hasSingleQuotes = css.indexOf(39) != -1;
        if (hasSingleQuotes) {
            if (hasDoubleQuotes) {
                char quote;
                int len = css.length();
                int sqc = 0;
                int dqc = 0;
                int i = 0;
                while (i < len) {
                    char c = css.charAt(i);
                    if (c == '\'') {
                        ++sqc;
                    } else if (c == '\"') {
                        ++dqc;
                    }
                    ++i;
                }
                if (sqc > dqc) {
                    quote = '\"';
                } else {
                    quote = '\'';
                    useDQ = false;
                }
                StringBuilder buf = new StringBuilder(len + 8);
                int i2 = 0;
                while (i2 < len) {
                    char c = css.charAt(i2);
                    if (c == quote) {
                        buf.append('\\');
                    }
                    buf.append(c);
                    ++i2;
                }
                css = buf.toString();
            }
        } else if (hasDoubleQuotes) {
            useDQ = false;
        }
        if (css.indexOf(10) != -1) {
            css = CSSStringValue.escapeLF(css);
        }
        if (css.indexOf(32) != -1 || hasSingleQuotes || hasDoubleQuotes) {
            if (useDQ) {
                this.setCssText("\"" + css + "\"");
            } else {
                this.setCssText("'" + css + "'");
            }
        } else {
            this.setCssText(css);
        }
    }

    static String escapeLF(String strval) {
        int len = strval.length();
        StringBuilder buf = new StringBuilder(len + 8);
        int i = 0;
        while (i < len) {
            char c = strval.charAt(i);
            if (c == '\n') {
                buf.append("\\A");
            } else {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    static String unescapeLF(String strval) {
        char[] esc1 = "A".toCharArray();
        char[] esc2 = "00000a".toCharArray();
        char[] esc3 = "00000A".toCharArray();
        boolean unescaped = false;
        int len = strval.length();
        StringBuilder buf = null;
        int i = 0;
        while (i < len) {
            char c = strval.charAt(i);
            ++i;
            if (c == '\\') {
                if (CSSStringValue.compareToCharArray(strval, i, len, esc1)) {
                    if (!unescaped) {
                        unescaped = true;
                        buf = new StringBuilder(len);
                        buf.append(strval.subSequence(0, i - 1));
                    }
                    buf.append('\n');
                    i += esc1.length;
                    continue;
                }
                if (CSSStringValue.compareToCharArray(strval, i, len, esc2)) {
                    if (!unescaped) {
                        unescaped = true;
                        buf = new StringBuilder(len);
                        buf.append(strval.subSequence(0, i - 1));
                    }
                    buf.append('\n');
                    i += esc2.length;
                    continue;
                }
                if (CSSStringValue.compareToCharArray(strval, i, len, esc3)) {
                    if (!unescaped) {
                        unescaped = true;
                        buf = new StringBuilder(len);
                        buf.append(strval.subSequence(0, i - 1));
                    }
                    buf.append('\n');
                    i += esc3.length;
                    continue;
                }
                if (!unescaped) continue;
                buf.append('\\');
                continue;
            }
            if (!unescaped) continue;
            buf.append(c);
        }
        if (unescaped) {
            return buf.toString();
        }
        return strval;
    }

    private static boolean compareToCharArray(String strval, int i, int len, char[] esc1) {
        int k = 0;
        while (i < len) {
            char c = strval.charAt(i);
            if (k == esc1.length) break;
            if (c != esc1[k]) {
                return false;
            }
            ++k;
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CSSStringValue)) {
            return false;
        }
        CSSStringValue other = (CSSStringValue)obj;
        return !(this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue));
    }

    @Override
    public CSSStringValue clone() {
        return new CSSStringValue(this);
    }

    @Override
    public String toString() {
        return this.stringValue;
    }
}

