/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSPropertyName;
import info.informatica.doc.style.css.property.ExtendedCSSValue;
import info.informatica.doc.style.css.property.ShorthandPropertyName;
import info.informatica.doc.style.css.property.SubPropertyName;
import info.informatica.text.TokenParser;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyDatabase {
    private ClassLoader classLoader = null;
    private Map<String, CSSPropertyName> nameMap = new HashMap<String, CSSPropertyName>(42);
    private List<String> inherited_properties;
    private Map<String, String[]> shorthand2subp = new HashMap<String, String[]>();
    private Map<String, String> subp2shorthand = new HashMap<String, String>();
    private Properties identifiers;
    private Map<String, ExtendedCSSValue> initialValueMap;
    private static PropertyDatabase singleton = new PropertyDatabase();
    static Logger log = LoggerFactory.getLogger((String)PropertyDatabase.class.getName());

    protected PropertyDatabase() {
        this.inherited_properties = this.computeInheritedPropertiesList();
        Properties shand = this.loadPropertiesfromClasspath("shorthand.properties");
        ArrayList<String> array = new ArrayList<String>();
        for (Map.Entry<Object, Object> me : shand.entrySet()) {
            String shname = (String)me.getKey();
            String subpties = (String)me.getValue();
            StringTokenizer st = new StringTokenizer(subpties, ",");
            while (st.hasMoreTokens()) {
                array.add(st.nextToken().trim());
            }
            this.addShorthand(shname, array.toArray(new String[0]));
            array.clear();
        }
        this.identifiers = this.loadPropertiesfromClasspath("identifier.properties");
        this.initialValueMap = this.computeInitialValueMap();
    }

    public static PropertyDatabase getInstance() {
        return singleton;
    }

    public boolean isInherited(String name) {
        return this.inherited_properties.contains(name);
    }

    protected List<String> computeInheritedPropertiesList() {
        String[] inherit = new String[]{"azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "page-break-inside", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "visibility", "voice-family", "volume", "white-space", "widows", "word-spacing"};
        return Arrays.asList(inherit);
    }

    public ExtendedCSSValue getInitialValue(String propertyName) {
        return this.initialValueMap.get(propertyName);
    }

    protected Map<String, ExtendedCSSValue> computeInitialValueMap() {
        String[][] initialArray = new String[][]{{"azimuth", "center"}, {"background-attachment", "scroll"}, {"background-clip", "border-box"}, {"background-color", "transparent"}, {"background-image", "none"}, {"background-origin", "padding-box"}, {"background-position", "0% 0%"}, {"background-repeat", "repeat"}, {"background-size", "auto"}, {"border-collapse", "separate"}, {"border-spacing", "0"}, {"border-top-style", "none"}, {"border-right-style", "none"}, {"border-bottom-style", "none"}, {"border-left-style", "none"}, {"border-top-width", "medium"}, {"border-right-width", "medium"}, {"border-bottom-width", "medium"}, {"border-left-width", "medium"}, {"border-image-outset", "0"}, {"border-image-repeat", "stretch"}, {"border-image-slice", "100%"}, {"border-image-source", "none"}, {"border-image-width", "1"}, {"border-top-left-radius", "0"}, {"border-top-right-radius", "0"}, {"border-bottom-right-radius", "0"}, {"border-bottom-left-radius", "0"}, {"bottom", "auto"}, {"box-decoration-break", "slice"}, {"box-shadow", "none"}, {"caption-side", "top"}, {"clear", "none"}, {"content", "normal"}, {"counter-increment", "none"}, {"counter-reset", "none"}, {"cue-after", "none"}, {"cue-before", "none"}, {"cursor", "auto"}, {"direction", "ltr"}, {"display", "inline"}, {"elevation", "level"}, {"empty-cells", "show"}, {"float", "none"}, {"font-size", "medium"}, {"font-style", "normal"}, {"font-variant", "normal"}, {"font-weight", "normal"}, {"height", "auto"}, {"left", "auto"}, {"letter-spacing", "normal"}, {"line-height", "normal"}, {"list-style-image", "none"}, {"list-style-position", "outside"}, {"list-style-type", "disc"}, {"margin-right", "0"}, {"margin-left", "0"}, {"margin-top", "0"}, {"margin-bottom", "0"}, {"max-height", "none"}, {"max-width", "none"}, {"min-height", "0"}, {"min-width", "0"}, {"opacity", "1"}, {"orphans", "2"}, {"outline-color", "invert"}, {"outline-style", "none"}, {"outline-width", "medium"}, {"overflow", "visible"}, {"padding-top", "0"}, {"padding-right", "0"}, {"padding-bottom", "0"}, {"padding-left", "0"}, {"page-break-after", "auto"}, {"page-break-before", "auto"}, {"page-break-inside", "auto"}, {"pause-after", "0"}, {"pause-before", "0"}, {"pitch-range", "50"}, {"pitch", "medium"}, {"play-during", "auto"}, {"position", "static"}, {"richness", "50"}, {"right", "auto"}, {"speak-header", "once"}, {"speak-numeral", "continuous"}, {"speak-punctuation", "none"}, {"speak", "normal"}, {"speech-rate", "medium"}, {"stress", "50"}, {"table-layout", "auto"}, {"text-decoration", "none"}, {"text-indent", "0"}, {"text-transform", "none"}, {"top", "auto"}, {"transition-property", "all"}, {"transition-duration", "0s"}, {"transition-timing-function", "ease"}, {"transition-delay", "0s"}, {"unicode-bidi", "normal"}, {"vertical-align", "baseline"}, {"visibility", "visible"}, {"voice-family", "male"}, {"volume", "medium"}, {"white-space", "normal"}, {"widows", "2"}, {"width", "auto"}, {"word-spacing", "normal"}, {"z-index", "auto"}};
        HashMap<String, ExtendedCSSValue> initialValueMap = new HashMap<String, ExtendedCSSValue>(initialArray.length);
        int i = 0;
        while (i < initialArray.length) {
            ExtendedCSSValue value = AbstractCSSValue.parseProperty(initialArray[i][1]);
            initialValueMap.put(initialArray[i][0], value);
            ++i;
        }
        return initialValueMap;
    }

    public boolean isShorthand(String name) {
        return this.shorthand2subp.containsKey(name);
    }

    public boolean isShorthandSubproperty(String name) {
        return this.subp2shorthand.containsKey(name);
    }

    public String getShorthand(String subproperty) {
        return this.subp2shorthand.get(subproperty);
    }

    public boolean isShorthandSubpropertyOf(String shorthand, String subpName) {
        String sh = this.subp2shorthand.get(subpName);
        if (sh == null) {
            return false;
        }
        if (sh.equals(shorthand)) {
            return true;
        }
        if (shorthand.equals(sh = this.subp2shorthand.get(sh))) {
            return true;
        }
        String[] subp = this.shorthand2subp.get(shorthand);
        int i = 0;
        while (i < subp.length) {
            if (subp[i].equals(subpName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getShorthandSubproperties(String shorthandName) {
        return this.shorthand2subp.get(shorthandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSPropertyName getPropertyName(String name) {
        CSSPropertyName pname = this.nameMap.get(name);
        if (pname == null) {
            Map<String, CSSPropertyName> map = this.nameMap;
            synchronized (map) {
                if (this.isShorthand(name)) {
                    pname = new ShorthandPropertyName(name, this.isInherited(name));
                    ((ShorthandPropertyName)pname).setSubProperties(this.shorthand2subp.get(name));
                } else if (this.isShorthandSubproperty(name)) {
                    pname = new SubPropertyName(name, this.isInherited(name));
                    ((SubPropertyName)pname).setShorthand(this.subp2shorthand.get(name));
                } else {
                    pname = new CSSPropertyName(name, this.isInherited(name));
                }
                this.nameMap.put(name, pname);
            }
        }
        return pname;
    }

    protected void addShorthand(String shorthand, String[] subproperties) {
        this.shorthand2subp.put(shorthand, subproperties);
        int i = 0;
        while (i < subproperties.length) {
            String prevSh = this.subp2shorthand.get(subproperties[i]);
            if (prevSh != null) {
                String topShorthand = this.subp2shorthand.get(shorthand);
                String topPrevSh = this.subp2shorthand.get(prevSh);
                if (topShorthand == null) {
                    if (topPrevSh != null) {
                        this.subp2shorthand.put(shorthand, topPrevSh);
                    }
                } else if (topPrevSh == null) {
                    this.subp2shorthand.put(prevSh, topShorthand);
                }
            }
            this.subp2shorthand.put(subproperties[i], shorthand);
            ++i;
        }
    }

    public boolean isIdentifierValue(String propertyName, String value) {
        String csl = this.identifiers.getProperty(propertyName);
        if (csl == null) {
            log.debug("Could not find identifiers for " + propertyName);
            return false;
        }
        TokenParser tokp = new TokenParser(csl, ",");
        while (tokp.hasNext()) {
            String s = tokp.nextToken();
            if (!s.trim().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    Properties loadPropertiesfromClasspath(final String filename) {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                InputStream is = PropertyDatabase.this.classLoader != null ? PropertyDatabase.this.classLoader.getResourceAsStream(PropertyDatabase.this.resourcePath(filename)) : this.getClass().getResourceAsStream(PropertyDatabase.this.resourcePath(filename));
                if (is == null) {
                    return null;
                }
                Properties p = new Properties();
                try {
                    try {
                        p.load(is);
                    }
                    catch (IOException e) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return null;
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return p;
            }
        });
    }

    protected String resourcePath(String filename) {
        return String.valueOf('/') + PropertyDatabase.class.getPackage().getName().replace('.', '/') + '/' + filename;
    }
}

