/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSDocument;
import info.informatica.doc.style.css.FormatterErrorHandler;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.visual.ReplacedElementBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractReplacedBox<C>
extends AbstractCSSBox
implements ReplacedElementBox<C> {
    private CSSStylableElement replacedElement;

    public AbstractReplacedBox(CSSStylableElement replaced) {
        super((CSS2ComputedProperties)replaced.getComputedStyle());
        this.replacedElement = replaced;
    }

    protected CSSStylableElement getReplacedElement() {
        return this.replacedElement;
    }

    public CSSDocument getDocument() {
        return this.replacedElement.getOwnerDocument();
    }

    @Override
    public float getWidth() {
        float boxWidth;
        CSSPrimitiveValue cssValue = (CSSPrimitiveValue)((Object)this.getCSSValue("width"));
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            boxWidth = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            boxWidth = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
        } else if (cssValue instanceof CSSNumberValue) {
            boxWidth = cssValue.getFloatValue(primiType);
        } else {
            block9: {
                String sWidth = this.replacedElement.attributeValue("width");
                if (sWidth != null && sWidth.length() > 0) {
                    try {
                        return Integer.parseInt(sWidth);
                    }
                    catch (NumberFormatException e) {
                        FormatterErrorHandler eh = this.getErrorHandler();
                        if (eh == null) break block9;
                        eh.parseValueError("width", sWidth, cssValue);
                    }
                }
            }
            boxWidth = this.getIntrinsicWidth();
        }
        return boxWidth;
    }

    @Override
    public float getHeight() {
        float boxHeight;
        CSSPrimitiveValue cssValue = (CSSPrimitiveValue)((Object)this.getCSSValue("height"));
        short primiType = cssValue.getPrimitiveType();
        if (primiType == this.getStyleDatabase().getNaturalUnit()) {
            boxHeight = cssValue.getFloatValue(this.getStyleDatabase().getNaturalUnit());
        } else if (primiType == 2) {
            boxHeight = this.getContainerWidth() * cssValue.getFloatValue((short)2) / 100.0f;
        } else if (cssValue instanceof CSSNumberValue) {
            boxHeight = cssValue.getFloatValue(primiType);
        } else {
            block9: {
                String sHeight = this.replacedElement.attributeValue("height");
                if (sHeight != null && sHeight.length() > 0) {
                    try {
                        return Integer.parseInt(sHeight);
                    }
                    catch (NumberFormatException e) {
                        FormatterErrorHandler eh = this.getErrorHandler();
                        if (eh == null) break block9;
                        eh.parseValueError("height", sHeight, cssValue);
                    }
                }
            }
            boxHeight = this.getIntrinsicHeight();
        }
        return boxHeight;
    }
}

