/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.debug;

import java.io.PrintStream;

public final class Benchmark {
    public static int[] counter;
    public static long[] timer;
    public static long[] acc;
    public static String[] label;

    public static void enable(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of channels must be at least 1");
        }
        counter = new int[n];
        timer = new long[n];
        acc = new long[n];
        label = new String[n];
    }

    public static void reset() {
        int i = 0;
        while (i < counter.length) {
            Benchmark.counter[i] = 0;
            Benchmark.timer[i] = 0L;
            Benchmark.acc[i] = 0L;
            Benchmark.label[i] = null;
            ++i;
        }
    }

    public static void reset(int channel) {
        Benchmark.counter[channel] = 0;
        Benchmark.timer[channel] = 0L;
        Benchmark.acc[channel] = 0L;
        Benchmark.label[channel] = null;
    }

    public static void label(int channel, String s) {
        Benchmark.label[channel] = s;
    }

    public static void start(int channel) {
        if (timer[0] == 0L) {
            Benchmark.timer[0] = System.currentTimeMillis();
        }
        Benchmark.timer[channel] = System.currentTimeMillis();
    }

    public static int stop(int channel) {
        if (timer[channel] == 0L) {
            return 0;
        }
        int n = channel;
        acc[n] = acc[n] + Benchmark.span(channel);
        Benchmark.timer[channel] = 0L;
        int n2 = channel;
        int n3 = counter[n2] + 1;
        counter[n2] = n3;
        return n3;
    }

    private static long span(int channel) {
        if (timer[channel] != 0L) {
            return System.currentTimeMillis() - timer[channel];
        }
        return 0L;
    }

    public static float speed(int channel) {
        if (counter[channel] == 0) {
            return 0.0f;
        }
        return (float)acc[channel] / (float)counter[channel];
    }

    public static int stop() {
        int c = 0;
        int i = 0;
        while (i < counter.length) {
            c += Benchmark.stop(i);
            ++i;
        }
        return c;
    }

    public static void printStatus(PrintStream ps) {
        ps.println();
        ps.println();
        ps.println("Benchmark status at time :" + Long.toString(acc[0] + Benchmark.span(0)));
        ps.println();
        int i = 0;
        while (i < counter.length) {
            if (counter[i] > 0) {
                Benchmark.printStatus(ps, i);
            }
            ++i;
        }
    }

    public static void printStatus(PrintStream ps, int channel) {
        if (label[channel] != null) {
            ps.println(label[channel]);
        } else {
            ps.println("Channel " + channel + ':');
        }
        ps.print("Counter: ");
        ps.println(counter[channel]);
        ps.print("Accumulated: ");
        ps.println(acc[channel] + Benchmark.span(channel));
        ps.print("Timed: ");
        ps.println(acc[channel]);
        ps.print("Avg. speed: ");
        ps.println(Benchmark.speed(channel));
        if (channel > 0) {
            ps.print("% to channel 0: ");
            ps.println(Math.floor((double)acc[channel] / (double)(acc[0] + Benchmark.span(0)) * 10000.0) * 0.01);
        }
        ps.println();
        ps.flush();
    }
}

