/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.AssociationException;
import info.informatica.io.ClassAssociation;
import info.informatica.io.Invocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Associator {
    private Map<String, ClassAssociation> assocmap = new HashMap<String, ClassAssociation>();
    private String encoding = null;

    public Associator(InputStream is) throws AssociationException {
        NodeList nl;
        Document doc;
        DocumentBuilder docb;
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        try {
            docb = dbFac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssociationException("Unable to parse stream: " + e.getMessage());
        }
        try {
            doc = docb.parse(is);
        }
        catch (SAXException e) {
            throw new AssociationException("Unable to parse stream: " + e.getMessage());
        }
        catch (IOException e) {
            throw new AssociationException("Unable to parse stream: " + e.getMessage());
        }
        Element root = doc.getDocumentElement();
        root.normalize();
        if (!"associator".equalsIgnoreCase(root.getNodeName())) {
            nl = root.getElementsByTagName("associator");
            if (nl.getLength() == 0) {
                throw new AssociationException("No <associator> element found.");
            }
            root = (Element)nl.item(0);
        }
        nl = root.getElementsByTagName("association");
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            String className = node.getAttributes().getNamedItem("class").getNodeValue();
            ClassAssociation assoc = new ClassAssociation(className);
            NodeList list = node.getChildNodes();
            this.addAssociation(assoc, list);
            ++i;
        }
    }

    private void addAssociation(ClassAssociation assoc, NodeList nl) throws AssociationException {
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                String lcname = node.getNodeName().toLowerCase(Locale.US);
                if ("extension".equals(lcname)) {
                    String ext = node.getFirstChild().getNodeValue();
                    this.assocmap.put(this.sanitize(ext), assoc);
                } else if ("invocation".equals(lcname)) {
                    Invocator inv = new Invocator();
                    NodeList list = node.getChildNodes();
                    int j = 0;
                    while (j < list.getLength()) {
                        node = list.item(j);
                        if (node.getNodeType() == 1) {
                            lcname = node.getNodeName().toLowerCase(Locale.US);
                            if ("member-name".equals(lcname)) {
                                inv.setMemberName(this.sanitize(node.getFirstChild().getNodeValue()));
                            } else if ("argument-list".equals(lcname)) {
                                NodeList alist = node.getChildNodes();
                                int k = 0;
                                while (k < alist.getLength()) {
                                    node = alist.item(k);
                                    if (node.getNodeType() == 1 && "argument".equals(lcname = node.getNodeName().toLowerCase(Locale.US))) {
                                        String arg_class = null;
                                        String arg_type = null;
                                        String arg_use = null;
                                        NodeList blist = node.getChildNodes();
                                        int l = 0;
                                        while (l < blist.getLength()) {
                                            node = blist.item(l);
                                            lcname = node.getNodeName().toLowerCase(Locale.US);
                                            if ("arg-class".equals(lcname)) {
                                                arg_class = this.sanitize(node.getFirstChild().getNodeValue());
                                            } else if ("arg-type".equals(lcname)) {
                                                arg_type = this.sanitize(node.getFirstChild().getNodeValue());
                                            } else if ("arg-use".equals(lcname)) {
                                                arg_use = this.sanitize(node.getFirstChild().getNodeValue());
                                            }
                                            ++l;
                                        }
                                        if (arg_class != null && arg_type != null) {
                                            inv.addArgument(arg_class, arg_type, arg_use);
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                    assoc.addInvocation(inv);
                }
            }
            ++i;
        }
    }

    private String sanitize(String ext) {
        String s = ext.replace("\n", "");
        s = s.replace("\t", "");
        return s.trim();
    }

    public Associator() {
        try {
            ClassAssociation assoc = new ClassAssociation("java.util.Properties");
            Invocator inv = new Invocator();
            assoc.addInvocation(inv);
            inv = new Invocator();
            inv.addArgument("java.io.InputStream", "InputStream", "java.io.InputStream");
            inv.setMemberName("load");
            assoc.addInvocation(inv);
            this.assocmap.put("properties", assoc);
        }
        catch (AssociationException e) {
            throw new IllegalStateException(e.getLocalizedMessage());
        }
    }

    public void addAssociation(String ext, ClassAssociation assoc) {
        this.assocmap.put(ext, assoc);
    }

    public ClassAssociation getAssociation(String ext) {
        return this.assocmap.get(ext);
    }

    public Set<String> getExtensions() {
        return this.assocmap.keySet();
    }

    public Object create(InputStream is, URL url, String ext) throws IOException {
        ClassAssociation assoc = this.getAssociation(ext);
        if (assoc == null) {
            return null;
        }
        return assoc.create(is, url);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("<associator>\n");
        for (Map.Entry<String, ClassAssociation> me : this.assocmap.entrySet()) {
            String ext = me.getKey();
            ClassAssociation assoc = me.getValue();
            sb.append("<association>\n<extension>\n").append(ext).append("\n</extension>\n").append(assoc.toString()).append("\n</association>");
        }
        sb.append("\n</associator>");
        return sb.toString();
    }
}

