/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

import info.informatica.util.CacheException;
import info.informatica.util.DatedContainer;
import info.informatica.util.ObjectCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDNSCache
extends ObjectCache {
    public static final String DNS_CACHE_FILE = "dns.cache.file";
    protected Properties p;
    protected long exptime = 10368000000L;
    private File f = null;

    @Override
    public void init(Properties conf) throws CacheException {
        String s = conf.getProperty(DNS_CACHE_FILE);
        this.p = new Properties();
        if (s != null) {
            try {
                this.f = new File(s);
                if (this.f.canRead()) {
                    this.open(this.f);
                }
            }
            catch (IOException e) {
                throw new CacheException(e.getMessage());
            }
        }
        if ((s = conf.getProperty("dns.cache.expire")) != null) {
            this.setExpireTime(Long.parseLong(s) * 1000L);
        }
    }

    private synchronized void open(File f) throws IOException {
        this.f = f;
        FileInputStream in = new FileInputStream(f);
        this.p.load(in);
        in.close();
    }

    @Override
    public void setExpireTime(long t) {
        this.exptime = t * 1000L;
    }

    @Override
    public String lookupString(String ip) {
        DatedContainer<String> dc = this.lookup(ip);
        if (dc == null) {
            return null;
        }
        String s = dc.getObject();
        dc = null;
        if (s == null) {
            return "";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatedContainer<String> lookup(String ip) {
        String h;
        Properties properties = this.p;
        synchronized (properties) {
            h = this.p.getProperty(ip);
        }
        if (h != null) {
            int i = h.lastIndexOf(58);
            String f = h.substring(i + 1);
            long t = Long.parseLong(f);
            if (i == 0) {
                return new DatedContainer<Object>(new Date(t), null);
            }
            h = h.substring(0, i);
            if (new Date().getTime() - t > this.exptime) {
                return null;
            }
            return new DatedContainer<String>(new Date(t), h);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String ip, String name) {
        if (ip != null) {
            Properties properties = this.p;
            synchronized (properties) {
                this.p.put(ip, String.valueOf(name == null ? "" : name) + ":" + new Date().getTime());
            }
        }
    }

    @Override
    public synchronized void put(String ip, DatedContainer<String> dc) {
        this.put(ip, dc.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws CacheException {
        FileOutputStream os = null;
        if (this.f != null) {
            try {
                try {
                    os = new FileOutputStream(this.f);
                    Properties properties = this.p;
                    synchronized (properties) {
                        this.p.store(os, "DNS cache");
                    }
                }
                catch (IOException e) {
                    throw new CacheException(e.getMessage());
                }
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

