/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

import info.informatica.net.InetUtil;
import info.informatica.net.ResolverListener;
import info.informatica.text.mapper.LeftReplaceMapper;
import info.informatica.text.mapper.MapperException;
import info.informatica.text.mapper.TextMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.ListIterator;

public class RevDNSThread
extends Thread {
    private ResolverListener hl;
    private static LinkedList<String> ip = new LinkedList();
    protected TextMapper unresolv = new LeftReplaceMapper();
    private static volatile boolean parar;

    public RevDNSThread(ResolverListener hl) throws IOException {
        this.hl = hl;
    }

    public RevDNSThread(ResolverListener hl, String s) throws IOException, MapperException {
        this.hl = hl;
        if (s != null) {
            BufferedReader buf = new BufferedReader(new FileReader(s));
            this.unresolv.init(buf);
            buf.close();
        }
    }

    public synchronized void add(String addr) {
        ip.addLast(addr);
        this.hl.notifyAll();
    }

    public static synchronized boolean contains(String addr) {
        return ip.contains(addr);
    }

    public static synchronized boolean isEmpty() {
        return ip.isEmpty();
    }

    public void start() {
        parar = false;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ListIterator it = ip.listIterator();
        ResolverListener resolverListener = this.hl;
        synchronized (resolverListener) {
            while (true) {
                if (parar) {
                    return;
                }
                while (it.hasNext() && !parar) {
                    String addr = (String)it.next();
                    String name = RevDNSThread.lookupRevDns(addr);
                    LinkedList<String> linkedList = ip;
                    synchronized (linkedList) {
                        this.hl.entryResolved(addr, name);
                        it.remove();
                    }
                }
                try {
                    this.hl.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final synchronized void parar() {
        parar = true;
    }

    public static final String lookupRevDns(String ip) {
        String h = null;
        try {
            h = InetAddress.getByName(ip).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (InetUtil.isInetAddress(h)) {
            h = null;
        }
        return h;
    }
}

