/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class WhoisClient {
    private String server_addr;
    private int server_port;

    public static void main(String[] args) throws Exception {
        String query;
        WhoisClient whois;
        if (args.length != 3 && args.length != 2) {
            System.err.println("Usage: WhoisClient <host> [-p<port>] <querystring>");
            return;
        }
        if (args[1].startsWith("-p")) {
            whois = new WhoisClient(args[0], Integer.parseInt(args[1].substring(2)));
            query = args[2];
        } else {
            whois = new WhoisClient(args[0]);
            query = args[1];
        }
        System.out.println(whois.whois(query));
    }

    public WhoisClient(String server) {
        this(server, 43);
    }

    public WhoisClient(String server_address, int port) {
        this.server_addr = server_address;
        this.server_port = port;
    }

    public String whois(String query) throws IOException, UnknownHostException {
        String line;
        Socket so = new Socket(this.server_addr, this.server_port);
        BufferedReader sin = new BufferedReader(new InputStreamReader(so.getInputStream()));
        PrintWriter sout = new PrintWriter(so.getOutputStream(), true);
        sout.println(query);
        StringBuffer sb = new StringBuffer(200);
        while ((line = sin.readLine()) != null) {
            sb.append(line).append("\n");
        }
        so.close();
        return sb.toString();
    }
}

