/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

public final class StringUtil {
    public static String rightJustify(String s, char c, int n) {
        return StringUtil.rightJustify(s, c, n, c);
    }

    public static String rightJustify(String s, char c, int n, char overchar) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot right-justify String with zero width");
        }
        int l = n - s.length();
        if (l == 0) {
            return s;
        }
        if (l < 0) {
            return new StringBuffer(n).append(overchar).append(s.substring(-l + 1)).toString();
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        return new StringBuffer(n).append(ca).append(s).toString();
    }

    public static String leftJustify(String s, char c, int n) {
        return StringUtil.leftJustify(s, c, n, c);
    }

    public static String leftJustify(String s, char c, int n, char overchar) {
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot left-justify String with zero width");
        }
        int l = n - s.length();
        if (l == 0) {
            return s;
        }
        if (l < 0) {
            return new StringBuffer(n).append(s.substring(0, n - 1)).append(overchar).toString();
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        return new StringBuffer(n).append(s).append(ca).toString();
    }

    public static String toTitle(String s) {
        return String.valueOf(Character.toTitleCase(s.charAt(0))) + s.substring(1);
    }

    public static String fillString(String s, char c, int n) {
        int l = n - s.length();
        if (l < 0) {
            return s.substring(0, n);
        }
        if (l == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = c;
            ++i;
        }
        sb.append(ca);
        return sb.toString();
    }

    public static String contractSpaces(String t) {
        int tl = t.length();
        StringBuffer sb = new StringBuffer(tl);
        int ini = 0;
        int fin = 0;
        while ((ini = t.indexOf("  ", fin)) != -1) {
            sb.append(t.substring(fin, ini));
            fin = ini;
            while (++fin < tl && t.charAt(fin) == ' ') {
            }
            --fin;
        }
        sb.append(t.substring(fin));
        return sb.toString();
    }

    public static String filterISOControl(String s) {
        char[] c = s.toCharArray();
        StringBuffer sb = new StringBuffer(c.length);
        int i = 0;
        while (i < c.length) {
            if (!Character.isISOControl(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replaceISOControl(String s, char c) {
        char[] a = s.toCharArray();
        int i = 0;
        while (i < a.length) {
            if (Character.isISOControl(a[i])) {
                a[i] = c;
            }
            ++i;
        }
        return new String(a);
    }

    public static final String replaceNonChars(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] != ' ' && !Character.isLetterOrDigit(c[i])) {
                c[i] = 32;
            }
            ++i;
        }
        return new String(c);
    }

    public static String replaceLowerAccents(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            switch (c[i]) {
                case '\u00e0': 
                case '\u00e1': {
                    c[i] = 97;
                    break;
                }
                case '\u00e8': 
                case '\u00e9': {
                    c[i] = 101;
                    break;
                }
                case '\u00ec': 
                case '\u00ed': {
                    c[i] = 105;
                    break;
                }
                case '\u00f2': 
                case '\u00f3': {
                    c[i] = 111;
                    break;
                }
                case '\u00f9': 
                case '\u00fa': {
                    c[i] = 117;
                }
            }
            ++i;
        }
        return new String(c);
    }
}

