/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text;

import info.informatica.util.TypeUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenParser
implements Iterator<String> {
    private String l;
    private char[] sep;
    private char[] delim;
    private boolean last_token_found = false;
    private String next = null;
    private boolean ignore_consecutive_sep = false;
    private final boolean keepDelimiters;
    private char nextDelimiter = '\u0000';
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final String DEFAULT_DELIMITER = "\"";
    private static final int SEPARATOR_SIZE = 1;
    private char last_separator = '\u0000';
    private char next_separator = '\u0000';
    private final int ll;
    int ncom = -1;
    private int i = -1;
    private int lastdelim;

    public TokenParser(String line) {
        this(line, DEFAULT_SEPARATOR);
    }

    public TokenParser(String line, String separator) {
        this(line, separator, DEFAULT_DELIMITER);
    }

    public TokenParser(String line, String separator, String delimiters) {
        this(line, separator, delimiters, false);
    }

    public TokenParser(String line, String separator, String delimiters, boolean keepDelimiters) {
        this.l = line;
        this.keepDelimiters = keepDelimiters;
        if (separator == null || separator.length() == 0) {
            this.next = this.l;
            this.last_token_found = true;
            this.ll = 0;
            return;
        }
        this.sep = separator.toCharArray();
        this.delim = delimiters.toCharArray();
        boolean bl = this.ignore_consecutive_sep = this.isSeparator(' ') || this.isSeparator('\t');
        if (this.l == null || this.l.length() == 0) {
            this.next = null;
            this.ll = 0;
            return;
        }
        this.ll = this.l.length();
        this.findNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String last_next = this.next;
        this.last_separator = this.next_separator;
        this.findNext();
        return last_next;
    }

    public String nextToken() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void findNext() {
        if (this.last_token_found) {
            this.next = null;
            return;
        }
        int j = this.i + 1;
        StringBuilder prebuf = new StringBuilder();
        while (++this.i < this.ll - 1) {
            if (this.isDelimiter(this.l.charAt(this.i))) {
                this.setNextDelimiter();
                if (this.i - 1 > j) {
                    this.appendToToken(prebuf, this.i, j);
                } else if (this.keepDelimiters) {
                    prebuf.append(this.l.subSequence(this.i, this.i + 1));
                }
                j = this.i + 1;
                do {
                    ++this.i;
                } while (!this.isNextDelimiter(this.l.charAt(this.i)) && this.i < this.ll - 1);
                if (this.i >= this.ll - 1) break;
                ++this.ncom;
                this.appendToToken(prebuf, this.i, j);
                j = this.i + 1;
                continue;
            }
            if (!this.isSeparator(this.l.charAt(this.i))) continue;
            ++this.ncom;
            if (prebuf.length() > 0) {
                prebuf.append(this.l.subSequence(j, this.i));
                this.next = prebuf.toString();
            } else {
                this.next = this.l.substring(j, this.i);
            }
            j = this.i + 1;
            this.setNextSeparator(this.l.charAt(this.i));
            if (this.ignore_consecutive_sep) {
                while (this.i < this.ll && this.isSeparator(this.l.charAt(j))) {
                    ++this.i;
                    ++j;
                }
            }
            return;
        }
        ++this.ncom;
        if (this.isDelimiter(this.l.charAt(this.ll - 1))) {
            this.i = this.ll - 2;
        }
        if (prebuf.length() > 0) {
            this.appendToToken(prebuf, this.i + 1, j);
            this.next = prebuf.toString();
        } else {
            this.next = this.l.substring(j, this.i + 1);
        }
        ++this.ncom;
        this.last_token_found = true;
    }

    private void appendToToken(StringBuilder prebuf, int i, int j) {
        if (this.keepDelimiters) {
            ++i;
        }
        prebuf.append(this.l.subSequence(j, i));
    }

    private boolean isDelimiter(char c) {
        this.lastdelim = TokenParser.charInArray(this.l.charAt(this.i), this.delim);
        return this.lastdelim >= 0 || c == this.nextDelimiter;
    }

    private void setNextDelimiter() {
        this.nextDelimiter = this.delim[this.lastdelim];
        switch (this.nextDelimiter) {
            case '(': {
                this.nextDelimiter = (char)41;
                break;
            }
            case '[': {
                this.nextDelimiter = (char)93;
                break;
            }
            case '{': {
                this.nextDelimiter = (char)125;
            }
        }
    }

    private boolean isNextDelimiter(char c) {
        return c == this.nextDelimiter;
    }

    private boolean isSeparator(char c) {
        return TokenParser.charInArray(c, this.sep) >= 0;
    }

    private static int charInArray(char c, char[] ca) {
        int j = 0;
        while (j < ca.length) {
            if (c == ca[j]) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private void setNextSeparator(char csep) {
        this.next_separator = csep;
    }

    public char getLastSeparator() {
        return this.last_separator;
    }

    public char getNextSeparator() {
        return this.next_separator;
    }

    public static String[] tokenize(String l, String sep, char[] delim, int init_size) {
        int ncom = -1;
        String[] c = new String[init_size];
        if (l == null || l.equals("")) {
            return null;
        }
        if (sep == null || sep.equals("")) {
            c[0] = l;
            return c;
        }
        int ll = l.length();
        int ls = sep.length();
        int i = 0;
        int j = 0;
        while (i < ll - ls) {
            int lastdelim = TokenParser.charInArray(l.charAt(i), delim);
            if (lastdelim >= 0) {
                j = i + 1;
                while (l.charAt(++i) != delim[lastdelim] && i < ll - 1) {
                }
                if (i >= ll - 1) break;
                c = TypeUtil.safeArrayAssign(c, ++ncom, l.substring(j, i));
                j = ++i + 1;
                if (sep.equals(" ")) {
                    while (i < ll && l.substring(j, j + ls).equals(sep)) {
                        ++i;
                        ++j;
                    }
                }
            } else if (l.substring(i, i + ls).equals(sep)) {
                c = TypeUtil.safeArrayAssign(c, ++ncom, l.substring(j, i));
                j = i + ls;
                if (sep.equals(" ")) {
                    while (i < ll && l.substring(j, ls + j).equals(sep)) {
                        ++i;
                        ++j;
                    }
                }
            }
            ++i;
        }
        ++ncom;
        if (TokenParser.charInArray(l.charAt(ll - 1), delim) >= 0) {
            i = ll - 2;
        }
        if (++ncom == (c = TypeUtil.safeArrayAssign(c, ncom, l.substring(j, i + ls))).length) {
            return c;
        }
        String[] d = new String[ncom];
        System.arraycopy(c, 0, d, 0, d.length);
        return d;
    }
}

