/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text.format;

import info.informatica.text.format.NumberFormat;
import info.informatica.text.format.SpecParsingException;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;

public class FloatFormat
extends NumberFormat {
    protected boolean numpre = false;
    private DecimalFormatSymbols symbols;

    public FloatFormat() {
        this.precision = 6;
        this.symbols = new DecimalFormatSymbols();
    }

    public static FloatFormat create(String format, Locale locale) throws SpecParsingException {
        return FloatFormat.create(format, new DecimalFormatSymbols(locale));
    }

    public static FloatFormat create(String format, DecimalFormatSymbols symbols) throws SpecParsingException {
        FloatFormat fmt = (FloatFormat)FloatFormat.create(format);
        fmt.setDecimalFormatSymbols(symbols);
        return fmt;
    }

    protected boolean setFlag(char flag, int i) {
        if (!super.setFlag(flag, i)) {
            switch (flag) {
                case '#': {
                    this.numpre = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String format(Object o) {
        if (!(o instanceof Double) && !(o instanceof Float)) {
            throw new IllegalArgumentException("Object must be a Double or a Float");
        }
        return this.roundFixedPointNumber((Number)o);
    }

    private final String roundFixedPointNumber(Number num) {
        StringBuffer numbuf;
        block41: {
            char decimalPoint;
            int hasSign;
            int negative;
            int rlen;
            String strRounded;
            block40: {
                int i;
                double dnumero = num.doubleValue();
                long rounded = Math.round(dnumero * (double)this.getRoundingFactor());
                strRounded = Long.toString(rounded).trim();
                rlen = strRounded.length();
                if (rounded == 0L && this.precision == 0) {
                    StringBuffer numbuf2 = new StringBuffer(this.width);
                    int i2 = 0;
                    while (i2 < this.width) {
                        numbuf2.append(' ');
                        ++i2;
                    }
                    return numbuf2.toString();
                }
                negative = strRounded.charAt(0) == '-' ? 1 : 0;
                hasSign = 0;
                if (this.signpre || negative == 1) {
                    hasSign = 1;
                }
                decimalPoint = this.symbols.getDecimalSeparator();
                numbuf = new StringBuffer(rlen >= this.width ? rlen + 1 : this.width + 1);
                if (rlen - negative > this.precision) break block40;
                if (this.ralign) {
                    if (this.zeropadding) {
                        if (negative == 1) {
                            numbuf.append('-');
                        } else if (this.signpre) {
                            numbuf.append('+');
                        }
                        i = this.precision + hasSign + 2;
                        while (i < this.width) {
                            numbuf.append('0');
                            ++i;
                        }
                    } else {
                        i = this.precision + hasSign + 2;
                        while (i < this.width) {
                            numbuf.append(' ');
                            ++i;
                        }
                        if (negative == 1) {
                            numbuf.append('-');
                        } else if (this.signpre) {
                            numbuf.append('+');
                        }
                    }
                } else if (negative == 1) {
                    numbuf.append('-');
                } else if (this.signpre) {
                    numbuf.append('+');
                }
                numbuf.append('0').append(decimalPoint);
                i = rlen - negative;
                while (i < this.precision) {
                    numbuf.append('0');
                    ++i;
                }
                numbuf.append(strRounded.subSequence(negative, rlen));
                if (this.ralign) break block41;
                i = rlen + this.precision + 1;
                while (i < this.width) {
                    numbuf.append(' ');
                    ++i;
                }
                break block41;
            }
            CharSequence intPart = strRounded.subSequence(negative, rlen - this.precision);
            CharSequence fractPart = strRounded.subSequence(rlen - this.precision, rlen);
            int nwsChars = intPart.length() + fractPart.length() + 1;
            if (this.ralign) {
                if (fractPart.length() > 0) {
                    this.leftPadding(negative, hasSign, nwsChars, numbuf);
                    numbuf.append(intPart).append(decimalPoint).append(fractPart);
                } else if (this.numpre) {
                    this.leftPadding(negative, hasSign, nwsChars, numbuf);
                    numbuf.append(intPart).append(decimalPoint);
                } else {
                    this.leftPadding(negative, hasSign, nwsChars - 1, numbuf);
                    numbuf.append(intPart);
                }
            } else {
                if (fractPart.length() > 0) {
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart).append(decimalPoint).append(fractPart);
                } else if (this.numpre) {
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart).append(decimalPoint);
                } else {
                    numbuf.append(' ');
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart);
                }
                int i = nwsChars;
                while (i < this.width) {
                    numbuf.append(' ');
                    ++i;
                }
            }
        }
        return numbuf.toString();
    }

    private void leftPadding(int negative, int hasSign, int nwsChars, StringBuffer numbuf) {
        if (this.zeropadding) {
            if (negative == 1) {
                numbuf.append('-');
            } else if (this.signpre) {
                numbuf.append('+');
            }
            int i = nwsChars + hasSign;
            while (i < this.width) {
                numbuf.append('0');
                ++i;
            }
        } else {
            int i = nwsChars + hasSign;
            while (i < this.width) {
                numbuf.append(' ');
                ++i;
            }
            if (negative == 1) {
                numbuf.append('-');
            } else if (this.signpre) {
                numbuf.append('+');
            }
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols symbols) {
        this.symbols = symbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.numpre) {
            sb.append('#');
        }
        if (this.zeropadding) {
            sb.append('0');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision >= 0) {
            sb.append('.').append(this.precision);
        }
        sb.append('f');
        return sb.toString();
    }

    public Object sample() {
        return new Double(new Random().nextDouble() * 10.0);
    }
}

