/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util;

import info.informatica.text.ParsingException;
import java.util.Properties;

public class EnvironProperties
extends Properties {
    private static final long serialVersionUID = 2L;
    private int max_indirection_level = 20;
    private boolean parseProperties = true;
    private String key_prefix = null;

    public EnvironProperties() {
    }

    public EnvironProperties(Properties defaults) {
        super(defaults);
    }

    public void setRecursionLevel(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Recursion level cannot be less than 1");
        }
        this.max_indirection_level = max;
    }

    public String parse(String line) throws ParsingException {
        return this.parse(line, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String parse(String line, int indirection_level) throws ParsingException {
        int i;
        if (line == null) {
            return null;
        }
        if (indirection_level >= this.max_indirection_level) {
            throw new ParsingException("Reached loop limit: " + indirection_level);
        }
        StringBuffer sb = new StringBuffer(line.length() + 20);
        int j = 0;
        while ((i = line.indexOf(36, j)) >= 0) {
            sb.append(line.substring(j, i));
            j = line.indexOf(123, ++i);
            if (j == -1) {
                j = i + 1;
                continue;
            }
            if (i == j) {
                if ((j = line.indexOf(125, ++i)) < 0) throw new ParsingException("Unmatched '${' pair at char " + Integer.toString(i));
                String s = this.getUnparsedProperty(line.substring(i, j));
                try {
                    s = this.parse(s, indirection_level + 1);
                }
                catch (ParsingException parsingException) {
                    // empty catch block
                }
                if (s != null) {
                    sb.append(s);
                }
            } else {
                sb.append('$');
                j = i - 1;
            }
            ++j;
        }
        sb.append(line.substring(j));
        return sb.toString();
    }

    public void setParse(boolean doparsing) {
        this.parseProperties = doparsing;
    }

    public String getProperty(String key) {
        String plain = this.getUnparsedProperty(key);
        if (!this.parseProperties) {
            return plain;
        }
        try {
            return this.parse(plain, 0);
        }
        catch (ParsingException e) {
            return plain;
        }
    }

    public String getUnparsedProperty(String key) {
        String pkey = this.prefixKey(key);
        Object o = super.get(pkey);
        String pty = null;
        if (o instanceof String) {
            pty = (String)o;
        }
        if (pty == null && this.defaults != null) {
            pty = this.defaults instanceof EnvironProperties ? ((EnvironProperties)this.defaults).getUnparsedProperty(pkey) : this.defaults.getProperty(pkey);
        }
        return pty;
    }

    public synchronized void setKeyPrefix(String prefix) {
        this.key_prefix = prefix;
    }

    private String prefixKey(String key) {
        if (this.key_prefix == null) {
            return key;
        }
        StringBuffer sb = new StringBuffer(this.key_prefix.length() + key.length() + 1);
        return sb.append(this.key_prefix).append('.').append(key).toString();
    }
}

