/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattedResourceBundle {
    private Hashtable<String, Object> lista = new Hashtable(22);
    private String res_name;
    private FormattedResourceBundle parent = null;

    private FormattedResourceBundle(String resname, InputStream is) throws IOException {
        String s;
        this.res_name = resname;
        BufferedReader re = new BufferedReader(new InputStreamReader(is));
        while ((s = re.readLine()) != null) {
            int i = s.indexOf(61);
            String clave = s.substring(0, i);
            if ((s = s.substring(++i)).indexOf("{0") != -1) {
                this.lista.put(clave, new MessageFormat(s));
                continue;
            }
            this.lista.put(clave, s);
        }
    }

    public String getString(String key) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            return ((MessageFormat)obj).toPattern();
        }
        return (String)obj;
    }

    public String formatString(String key, String arg) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            Object[] o = new Object[]{arg};
            return ((MessageFormat)obj).format(o);
        }
        return (String)obj;
    }

    public String formatString(String key, String arg1, String arg2) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            Object[] o = new Object[]{arg1, arg2};
            return ((MessageFormat)obj).format(o);
        }
        return (String)obj;
    }

    public String formatString(String key, String arg, int i) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            Object[] o = new Object[]{arg, new Integer(i)};
            return ((MessageFormat)obj).format(o);
        }
        return (String)obj;
    }

    public String formatString(String key, Object[] o) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            return ((MessageFormat)obj).format(o);
        }
        return (String)obj;
    }

    public String formatString(String key, int i) {
        Object obj = this.getObject(key);
        if (obj instanceof MessageFormat) {
            Object[] o = new Object[]{new Integer(i)};
            return ((MessageFormat)obj).format(o);
        }
        return (String)obj;
    }

    public void setParent(FormattedResourceBundle parent) {
        this.parent = parent;
    }

    private Object getObject(String key) throws MissingResourceException {
        Object obj = this.lista.get(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for key", this.res_name, key);
            }
        }
        return obj;
    }

    public Enumeration<String> getKeys() {
        Enumeration<String> enu = null;
        enu = this.parent != null ? new Enumeration<String>(){
            private Enumeration<String> theseKeys;
            private Enumeration<String> parentKeys;
            private String o;
            {
                this.theseKeys = FormattedResourceBundle.this.lista.keys();
                this.parentKeys = FormattedResourceBundle.this.parent.getKeys();
                this.o = null;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.o == null) {
                    this.nextElement();
                }
                return this.o != null;
            }

            @Override
            public String nextElement() {
                String ret = this.o;
                if (this.theseKeys != null && this.theseKeys.hasMoreElements()) {
                    this.o = this.theseKeys.nextElement();
                } else {
                    this.theseKeys = null;
                    this.o = null;
                    while (this.o == null && this.parentKeys.hasMoreElements()) {
                        this.o = this.parentKeys.nextElement();
                        if (!FormattedResourceBundle.this.lista.containsKey(this.o)) continue;
                        this.o = null;
                    }
                }
                return ret;
            }
        } : this.lista.keys();
        return enu;
    }

    public static FormattedResourceBundle getLocalBundle(String baseName) throws MissingResourceException {
        return FormattedResourceBundle.getLocalBundle(baseName, Locale.getDefault());
    }

    public static FormattedResourceBundle getLocalBundle(String baseName, Locale locale) {
        return FormattedResourceBundle.getLocalBundle(baseName, locale, null);
    }

    public static FormattedResourceBundle getLocalBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        String localeName;
        FormattedResourceBundle rb;
        String baseFileName = baseName.replace('.', '/');
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        if (la != null && (va != null ? (rb = FormattedResourceBundle.loadBundle(baseFileName, localeName = String.valueOf('_') + co + '_' + la + '_' + va, loader)) != null : (rb = FormattedResourceBundle.loadBundle(baseFileName, localeName = String.valueOf('_') + co + '_' + la, loader)) != null)) {
            return rb;
        }
        localeName = String.valueOf('_') + co;
        rb = FormattedResourceBundle.loadBundle(baseFileName, localeName, loader);
        if (rb != null) {
            return rb;
        }
        rb = FormattedResourceBundle.loadBundle(baseFileName, null, loader);
        if (rb != null) {
            return rb;
        }
        throw new MissingResourceException("Can't find formatted resource for base name ", String.valueOf(baseName) + '_' + locale.toString(), "");
    }

    private static FormattedResourceBundle loadBundle(String baseFileName, String localeName, ClassLoader loader) {
        String resName = localeName != null ? String.valueOf(baseFileName) + localeName + ".properties" : String.valueOf(baseFileName) + ".properties";
        InputStream is = FormattedResourceBundle.loadResource(resName, loader);
        if (is != null) {
            try {
                FormattedResourceBundle formattedResourceBundle = new FormattedResourceBundle(resName, is);
                return formattedResourceBundle;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static InputStream loadResource(final String name, final ClassLoader loader) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
                return this.getClass().getResourceAsStream(name);
            }
        });
    }
}

