/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.config.validation;

import io.aeron.config.ConfigInfo;
import io.aeron.config.ExpectedCConfig;
import io.aeron.config.validation.Entry;
import io.aeron.config.validation.Validation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

final class ValidationReport {
    private final List<Entry> entries = new ArrayList<Entry>();

    ValidationReport() {
    }

    void addEntry(ConfigInfo configInfo, BiConsumer<Validation, ExpectedCConfig> validateCEnvVar, BiConsumer<Validation, ExpectedCConfig> validateCDefault) {
        Entry entry = new Entry(configInfo);
        ExpectedCConfig c = configInfo.expectations.c;
        if (c.exists) {
            this.validate(validateCEnvVar, entry.envVarValidation, c);
            if (c.skipDefaultValidation) {
                entry.defaultValidation.valid("skipped");
            } else {
                this.validate(validateCDefault, entry.defaultValidation, c);
            }
        }
        this.entries.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(BiConsumer<Validation, ExpectedCConfig> func, Validation validation, ExpectedCConfig c) {
        try {
            func.accept(validation, c);
        }
        catch (Exception e) {
            validation.invalid(e.getMessage());
            e.printStackTrace(validation.out());
        }
        finally {
            validation.close();
        }
    }

    void printOn(PrintStream out) {
        this.entries.forEach(entry -> entry.printOn(out));
    }

    void printFailuresOn(PrintStream out) {
        this.entries.forEach(entry -> entry.printFailuresOn(out));
    }
}

