/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;

class CreateReplayPublicationSession
implements Session {
    private final long correlationId;
    private final long recordingId;
    private final long replayPosition;
    private final long replayLength;
    private final long startPosition;
    private final long stopPosition;
    private final int segmentFileLength;
    private final int termBufferLength;
    private final int streamId;
    private long publicationRegistrationId;
    private final int fileIoMaxLength;
    private boolean isDone = false;
    private final Aeron aeron;
    private final Counter limitPositionCounter;
    private final ControlSession controlSession;
    private final ArchiveConductor conductor;

    CreateReplayPublicationSession(long correlationId, long recordingId, long replayPosition, long replayLength, long startPosition, long stopPosition, int segmentFileLength, int termBufferLength, int streamId, long publicationRegistrationId, int fileIoMaxLength, Counter limitPositionCounter, Aeron aeron, ControlSession controlSession, ArchiveConductor conductor) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.replayPosition = replayPosition;
        this.replayLength = replayLength;
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.segmentFileLength = segmentFileLength;
        this.termBufferLength = termBufferLength;
        this.streamId = streamId;
        this.publicationRegistrationId = publicationRegistrationId;
        this.fileIoMaxLength = fileIoMaxLength;
        this.limitPositionCounter = limitPositionCounter;
        this.aeron = aeron;
        this.controlSession = controlSession;
        this.conductor = conductor;
    }

    @Override
    public void close() {
        if (-1L != this.publicationRegistrationId) {
            this.aeron.asyncRemovePublication(this.publicationRegistrationId);
        }
    }

    @Override
    public void abort(String reason) {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public long sessionId() {
        return this.publicationRegistrationId;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (!this.isDone) {
            ExclusivePublication publication;
            try {
                publication = this.aeron.getExclusivePublication(this.publicationRegistrationId);
            }
            catch (Exception ex) {
                this.isDone = true;
                String msg = "failed to create replay publication: " + ex.getMessage();
                this.controlSession.sendErrorResponse(this.correlationId, msg);
                throw ex;
            }
            if (null != publication) {
                this.publicationRegistrationId = -1L;
                this.isDone = true;
                ++workCount;
                this.conductor.newReplaySession(this.correlationId, this.recordingId, this.replayPosition, this.replayLength, this.startPosition, this.stopPosition, this.segmentFileLength, this.termBufferLength, this.streamId, this.fileIoMaxLength, this.controlSession, this.limitPositionCounter, publication);
            }
        }
        return workCount;
    }
}

