/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.ChallengeDecoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ChallengeEncoder {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 59;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ChallengeEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 59;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 13;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ChallengeEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public ChallengeEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(59).schemaId(101).version(13);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ChallengeEncoder controlSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ChallengeEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int versionId() {
        return 3;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 16;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int versionNullValue() {
        return 0;
    }

    public static int versionMinValue() {
        return 2;
    }

    public static int versionMaxValue() {
        return 0xFFFFFF;
    }

    public ChallengeEncoder version(int value) {
        this.buffer.putInt(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int encodedChallengeId() {
        return 4;
    }

    public static String encodedChallengeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int encodedChallengeHeaderLength() {
        return 4;
    }

    public ChallengeEncoder putEncodedChallenge(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ChallengeEncoder putEncodedChallenge(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ChallengeDecoder decoder = new ChallengeDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 20, 13);
        return decoder.appendTo(builder);
    }
}

