/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;


/**
 * Control protocol response code.
 */
@SuppressWarnings("all")
public enum ControlResponseCode
{

    /**
     * Operation successful.
     */
    OK(0),


    /**
     * Error occurred during operation.
     */
    ERROR(1),


    /**
     * Recording id was unknown.
     */
    RECORDING_UNKNOWN(2),


    /**
     * Subscription id was unknown.
     */
    SUBSCRIPTION_UNKNOWN(3),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ControlResponseCode(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ControlResponseCode get(final int value)
    {
        switch (value)
        {
            case 0: return OK;
            case 1: return ERROR;
            case 2: return RECORDING_UNKNOWN;
            case 3: return SUBSCRIPTION_UNKNOWN;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
