/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;


/**
 * State of a recording in the Catalog.
 */
@SuppressWarnings("all")
public enum RecordingState
{

    /**
     * Recording is invalid.
     */
    INVALID(0),


    /**
     * Recording is valid.
     */
    VALID(1),


    /**
     * Recording was deleted.
     */
    DELETED(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    RecordingState(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static RecordingState get(final int value)
    {
        switch (value)
        {
            case 0: return INVALID;
            case 1: return VALID;
            case 2: return DELETED;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
