/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Subscription;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import org.agrona.collections.Object2ObjectHashMap;

class ListRecordingSubscriptionsSession
implements Session {
    private final long correlationId;
    private final int subscriptionCount;
    private int pseudoIndex;
    private int sent;
    private final int streamId;
    private final boolean applyStreamId;
    private boolean isDone = false;
    private final String channelFragment;
    private final Object2ObjectHashMap<String, Subscription> subscriptionByKeyMap;
    private final ControlSession controlSession;

    ListRecordingSubscriptionsSession(Object2ObjectHashMap<String, Subscription> subscriptionByKeyMap, int pseudoIndex, int subscriptionCount, int streamId, boolean applyStreamId, String channelFragment, long correlationId, ControlSession controlSession) {
        this.subscriptionByKeyMap = subscriptionByKeyMap;
        this.pseudoIndex = pseudoIndex;
        this.subscriptionCount = subscriptionCount;
        this.streamId = streamId;
        this.applyStreamId = applyStreamId;
        this.channelFragment = channelFragment;
        this.correlationId = correlationId;
        this.controlSession = controlSession;
    }

    @Override
    public void close() {
        this.controlSession.activeListing(null);
    }

    @Override
    public void abort(String reason) {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public long sessionId() {
        return -1L;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        int index = 0;
        int size = this.subscriptionByKeyMap.size();
        for (Subscription subscription : this.subscriptionByKeyMap.values()) {
            if (index++ < this.pseudoIndex) continue;
            if ((!this.applyStreamId || subscription.streamId() == this.streamId) && subscription.channel().contains(this.channelFragment)) {
                if (!this.controlSession.sendSubscriptionDescriptor(this.correlationId, subscription)) {
                    this.isDone = this.controlSession.isDone();
                    break;
                }
                ++workCount;
                if (++this.sent >= this.subscriptionCount) {
                    this.isDone = true;
                    break;
                }
            }
            this.pseudoIndex = index - 1;
        }
        if (!this.isDone && index >= size) {
            this.controlSession.sendSubscriptionUnknown(this.correlationId);
            this.isDone = true;
            ++workCount;
        }
        return workCount;
    }
}

