/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.client.RecordingSubscriptionDescriptorConsumer;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingSignalEventDecoder;
import io.aeron.archive.codecs.RecordingSubscriptionDescriptorDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

public final class RecordingSubscriptionDescriptorPoller {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingSubscriptionDescriptorDecoder recordingSubscriptionDescriptorDecoder = new RecordingSubscriptionDescriptorDecoder();
    private final RecordingSignalEventDecoder recordingSignalEventDecoder = new RecordingSignalEventDecoder();
    private final long controlSessionId;
    private final int fragmentLimit;
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onFragment);
    private final ErrorHandler errorHandler;
    private final RecordingSignalConsumer recordingSignalConsumer;
    private long correlationId;
    private int remainingSubscriptionCount;
    private boolean isDispatchComplete = false;
    private RecordingSubscriptionDescriptorConsumer subscriptionDescriptorConsumer;

    public RecordingSubscriptionDescriptorPoller(Subscription subscription, ErrorHandler errorHandler, long controlSessionId, int fragmentLimit) {
        this(subscription, errorHandler, AeronArchive.Configuration.NO_OP_RECORDING_SIGNAL_CONSUMER, controlSessionId, fragmentLimit);
    }

    public RecordingSubscriptionDescriptorPoller(Subscription subscription, ErrorHandler errorHandler, RecordingSignalConsumer recordingSignalConsumer, long controlSessionId, int fragmentLimit) {
        this.subscription = subscription;
        this.errorHandler = errorHandler;
        this.recordingSignalConsumer = recordingSignalConsumer;
        this.fragmentLimit = fragmentLimit;
        this.controlSessionId = controlSessionId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        if (this.isDispatchComplete) {
            this.isDispatchComplete = false;
        }
        return this.subscription.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, this.fragmentLimit);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public boolean isDispatchComplete() {
        return this.isDispatchComplete;
    }

    public int remainingSubscriptionCount() {
        return this.remainingSubscriptionCount;
    }

    public void reset(long correlationId, int subscriptionCount, RecordingSubscriptionDescriptorConsumer consumer) {
        this.correlationId = correlationId;
        this.subscriptionDescriptorConsumer = consumer;
        this.remainingSubscriptionCount = subscriptionCount;
        this.isDispatchComplete = false;
    }

    ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isDispatchComplete) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        switch (templateId) {
            case 1: {
                this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.controlResponseDecoder.controlSessionId() != this.controlSessionId) break;
                ControlResponseCode code = this.controlResponseDecoder.code();
                long responseCorrelationId = this.controlResponseDecoder.correlationId();
                if (ControlResponseCode.SUBSCRIPTION_UNKNOWN == code && responseCorrelationId == this.correlationId) {
                    this.isDispatchComplete = true;
                    return ControlledFragmentHandler.Action.BREAK;
                }
                if (ControlResponseCode.ERROR != code) break;
                ArchiveException ex = new ArchiveException("response for correlationId=" + this.correlationId + ", error: " + this.controlResponseDecoder.errorMessage(), (int)this.controlResponseDecoder.relevantId(), responseCorrelationId);
                if (responseCorrelationId == this.correlationId) {
                    throw ex;
                }
                if (null == this.errorHandler) break;
                this.errorHandler.onError((Throwable)((Object)ex));
                break;
            }
            case 23: {
                this.recordingSubscriptionDescriptorDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.recordingSubscriptionDescriptorDecoder.controlSessionId() != this.controlSessionId || this.recordingSubscriptionDescriptorDecoder.correlationId() != this.correlationId) break;
                this.subscriptionDescriptorConsumer.onSubscriptionDescriptor(this.controlSessionId, this.correlationId, this.recordingSubscriptionDescriptorDecoder.subscriptionId(), this.recordingSubscriptionDescriptorDecoder.streamId(), this.recordingSubscriptionDescriptorDecoder.strippedChannel());
                if (0 != --this.remainingSubscriptionCount) break;
                this.isDispatchComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
            case 24: {
                this.recordingSignalEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.controlSessionId != this.recordingSignalEventDecoder.controlSessionId()) break;
                this.recordingSignalConsumer.onSignal(this.recordingSignalEventDecoder.controlSessionId(), this.recordingSignalEventDecoder.correlationId(), this.recordingSignalEventDecoder.recordingId(), this.recordingSignalEventDecoder.subscriptionId(), this.recordingSignalEventDecoder.position(), this.recordingSignalEventDecoder.signal());
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

