/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public final class Header {
    private Object context;
    private int positionBitsToShift;
    private int initialTermId;
    private int offset = 0;
    private DirectBuffer buffer;
    private int fragmentedFrameLength = -1;

    public Header(int initialTermId, int positionBitsToShift) {
        this(initialTermId, positionBitsToShift, null);
    }

    public Header(int initialTermId, int positionBitsToShift, Object context) {
        this.initialTermId = initialTermId;
        this.positionBitsToShift = positionBitsToShift;
        this.context = context;
    }

    public Object context() {
        return this.context;
    }

    public Header context(Object context) {
        this.context = context;
        return this;
    }

    public long position() {
        return LogBufferDescriptor.computePosition(this.termId(), this.nextTermOffset(), this.positionBitsToShift, this.initialTermId);
    }

    public int positionBitsToShift() {
        return this.positionBitsToShift;
    }

    public Header positionBitsToShift(int positionBitsToShift) {
        this.positionBitsToShift = positionBitsToShift;
        return this;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public Header initialTermId(int initialTermId) {
        this.initialTermId = initialTermId;
        return this;
    }

    public Header offset(int offset) {
        this.offset = offset;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public Header buffer(DirectBuffer buffer) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        return this;
    }

    public int frameLength() {
        return this.buffer.getInt(this.offset, ByteOrder.LITTLE_ENDIAN);
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public int termId() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public int termOffset() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public int nextTermOffset() {
        return BitUtil.align((int)(this.termOffset() + this.termOccupancyLength()), (int)32);
    }

    public int type() {
        return this.buffer.getShort(this.offset + 6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public byte flags() {
        return this.buffer.getByte(this.offset + 5);
    }

    public long reservedValue() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public void fragmentedFrameLength(int fragmentedFrameLength) {
        this.fragmentedFrameLength = fragmentedFrameLength;
    }

    public int fragmentedFrameLength() {
        return this.fragmentedFrameLength;
    }

    private int termOccupancyLength() {
        return -1 == this.fragmentedFrameLength ? this.frameLength() : this.fragmentedFrameLength;
    }
}

