/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TermGapScanner {
    public static int scanForGap(UnsafeBuffer termBuffer, int termId, int termOffset, int limitOffset, GapHandler handler) {
        int frameLength;
        int offset = termOffset;
        while ((frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0 && (offset += BitUtil.align((int)frameLength, (int)32)) < limitOffset) {
        }
        int gapBeginOffset = offset;
        if (offset < limitOffset) {
            offset += 32;
            while (offset < limitOffset && 0 == FrameDescriptor.frameLengthVolatile(termBuffer, offset)) {
                offset += 32;
            }
            int gapLength = offset - gapBeginOffset;
            handler.onGap(termId, gapBeginOffset, gapLength);
        }
        return gapBeginOffset;
    }

    @FunctionalInterface
    public static interface GapHandler {
        public void onGap(int var1, int var2, int var3);
    }
}

