/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class ErrorFlyweight
extends HeaderFlyweight {
    public static final int SESSION_ID_FIELD_OFFSET = 8;
    public static final int STREAM_ID_FIELD_OFFSET = 12;
    public static final int RECEIVER_ID_FIELD_OFFSET = 16;
    public static final int GROUP_TAG_FIELD_OFFSET = 24;
    public static final int ERROR_CODE_FIELD_OFFSET = 32;
    public static final int ERROR_STRING_FIELD_OFFSET = 36;
    public static final int HEADER_LENGTH = 40;
    public static final int MAX_ERROR_MESSAGE_LENGTH = 1023;
    public static final int MAX_ERROR_FRAME_LENGTH = 1063;
    public static final int HAS_GROUP_ID_FLAG = 8;

    public ErrorFlyweight() {
    }

    public ErrorFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public ErrorFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public ErrorFlyweight sessionId(int sessionId) {
        this.putInt(8, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public ErrorFlyweight streamId(int streamId) {
        this.putInt(12, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLong(16, ByteOrder.LITTLE_ENDIAN);
    }

    public ErrorFlyweight receiverId(long receiverId) {
        this.putLong(16, receiverId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long groupTag() {
        return this.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public boolean hasGroupTag() {
        return 8 == (8 & this.flags());
    }

    public ErrorFlyweight groupTag(Long groupTag) {
        if (null == groupTag) {
            this.flags((short)(0xFFFFFFF7 & this.flags()));
        } else {
            this.putLong(24, groupTag);
            this.flags((short)(8 | this.flags()));
        }
        return this;
    }

    public int errorCode() {
        return this.getInt(32, ByteOrder.LITTLE_ENDIAN);
    }

    public ErrorFlyweight errorCode(int errorCode) {
        this.putInt(32, errorCode, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String errorMessage() {
        return this.getStringAscii(36);
    }

    public ErrorFlyweight errorMessage(String errorMessage) {
        int headerAndMessageLength = this.putStringAscii(36, errorMessage, ByteOrder.LITTLE_ENDIAN);
        this.frameLength(40 + (headerAndMessageLength - 4));
        return this;
    }

    public String toString() {
        return "ERROR{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(ErrorFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " error-code=" + this.errorCode() + " error-message=" + this.errorMessage() + "}";
    }
}

