/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.Counter;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.cluster.ClusterClientSession;
import io.aeron.cluster.EgressPublisher;
import io.aeron.cluster.LogPublisher;
import io.aeron.cluster.client.ClusterEvent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.Strings;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;

final class ClusterSession
implements ClusterClientSession {
    static final byte[] NULL_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    static final int MAX_ENCODED_PRINCIPAL_LENGTH = 4096;
    static final int MAX_ENCODED_MEMBERSHIP_QUERY_LENGTH = 4096;
    private final long id;
    private final int clusterMemberId;
    private final int responseStreamId;
    private final String responseChannel;
    private final String sessionInfo;
    private boolean hasNewLeaderEventPending = false;
    private boolean hasOpenEventPending = true;
    private long correlationId;
    private long openedLogPosition = -1L;
    private long closedLogPosition = -1L;
    private transient long timeOfLastActivityNs;
    private transient long ingressImageCorrelationId = -1L;
    private long responsePublicationId = -1L;
    private long counterRegistrationId = -1L;
    private Publication responsePublication;
    private Counter counter;
    private State state;
    private String responseDetail = null;
    private EventCode eventCode = null;
    private CloseReason closeReason = CloseReason.NULL_VAL;
    private byte[] encodedPrincipal = NULL_PRINCIPAL;
    private Action action = Action.CLIENT;
    private Object requestInput = null;

    ClusterSession(int clusterMemberId, long sessionId, int responseStreamId, String responseChannel, String sessionInfo) {
        this.id = sessionId;
        this.clusterMemberId = clusterMemberId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.sessionInfo = sessionInfo;
        this.state(State.INIT, "");
    }

    public void close(Aeron aeron, ErrorHandler errorHandler, String reason) {
        this.disconnect(aeron, errorHandler);
        this.state(State.CLOSED, reason);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    @Override
    public boolean isOpen() {
        return State.OPEN == this.state;
    }

    @Override
    public Publication responsePublication() {
        return this.responsePublication;
    }

    @Override
    public long timeOfLastActivityNs() {
        return this.timeOfLastActivityNs;
    }

    @Override
    public void timeOfLastActivityNs(long timeNs) {
        this.timeOfLastActivityNs = timeNs;
    }

    void loadSnapshotState(long correlationId, long openedLogPosition, long timeOfLastActivityNs, CloseReason closeReason) {
        this.openedLogPosition = openedLogPosition;
        this.timeOfLastActivityNs = timeOfLastActivityNs;
        this.correlationId = correlationId;
        this.closeReason = closeReason;
        if (CloseReason.NULL_VAL != closeReason) {
            this.state(State.CLOSING, closeReason.name());
        } else {
            this.state(State.OPEN, "openedLogPosition=" + openedLogPosition);
        }
    }

    int responseStreamId() {
        return this.responseStreamId;
    }

    String responseChannel() {
        return this.responseChannel;
    }

    void closing(CloseReason closeReason) {
        this.closeReason = closeReason;
        this.hasOpenEventPending = false;
        this.hasNewLeaderEventPending = false;
        this.timeOfLastActivityNs = 0L;
        this.state(State.CLOSING, closeReason.name());
    }

    CloseReason closeReason() {
        return this.closeReason;
    }

    void resetCloseReason() {
        this.closedLogPosition = -1L;
        this.closeReason = CloseReason.NULL_VAL;
    }

    void asyncConnect(Aeron aeron, MutableDirectBuffer tempBuffer, int clusterId) {
        this.counterRegistrationId = this.addSessionCounter(aeron, tempBuffer, clusterId);
        this.responsePublicationId = aeron.asyncAddPublication(this.responseChannel, this.responseStreamId);
    }

    void connect(ErrorHandler errorHandler, Aeron aeron, MutableDirectBuffer tempBuffer, int clusterId) {
        if (null != this.responsePublication) {
            throw new ClusterException("response publication already added");
        }
        this.counterRegistrationId = this.addSessionCounter(aeron, tempBuffer, clusterId);
        try {
            this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
        }
        catch (RegistrationException ex) {
            errorHandler.onError((Throwable)((Object)new ClusterException("failed to connect session response publication: " + ex.getMessage(), AeronException.Category.WARN)));
        }
    }

    void disconnect(Aeron aeron, ErrorHandler errorHandler) {
        if (-1L != this.responsePublicationId) {
            aeron.asyncRemovePublication(this.responsePublicationId);
            this.responsePublicationId = -1L;
        } else {
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.responsePublication);
            this.responsePublication = null;
        }
        if (-1L != this.counterRegistrationId) {
            aeron.asyncRemoveCounter(this.counterRegistrationId);
            this.counterRegistrationId = -1L;
        } else {
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.counter);
            this.counter = null;
        }
    }

    boolean isResponsePublicationConnected(Aeron aeron, long nowNs) {
        if (null == this.responsePublication && !aeron.isCommandActive(this.responsePublicationId)) {
            this.responsePublication = aeron.getPublication(this.responsePublicationId);
            this.responsePublicationId = -1L;
            this.counter = aeron.getCounter(this.counterRegistrationId);
            this.counterRegistrationId = -1L;
            if (null != this.responsePublication) {
                if (null != this.counter) {
                    AeronCounters.setReferenceId((AtomicBuffer)aeron.context().countersMetaDataBuffer(), (AtomicBuffer)aeron.context().countersValuesBuffer(), (int)this.counter.id(), (long)this.responsePublication.registrationId());
                    this.counter.setRelease(this.id);
                }
                this.timeOfLastActivityNs = nowNs;
                this.state(State.CONNECTING, "connecting");
            } else {
                this.state(State.INVALID, "responsePublication is null");
            }
        }
        return null != this.responsePublication && this.responsePublication.isConnected();
    }

    long tryClaim(int length, BufferClaim bufferClaim) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.tryClaim(length, bufferClaim);
    }

    long offer(DirectBuffer buffer, int offset, int length) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.offer(buffer, offset, length);
    }

    State state() {
        return this.state;
    }

    void state(State newState, String reason) {
        ClusterSession.logStateChange(this.clusterMemberId, this.id, this.action, this.state, newState, reason);
        this.state = newState;
    }

    void authenticate(byte[] encodedPrincipal) {
        if (encodedPrincipal != null) {
            this.encodedPrincipal = encodedPrincipal;
        }
        this.state(State.AUTHENTICATED, "authenticated");
    }

    void open(long openedLogPosition) {
        this.openedLogPosition = openedLogPosition;
        this.state(State.OPEN, "openedLogPosition=" + openedLogPosition);
    }

    boolean appendSessionToLogAndSendOpen(LogPublisher logPublisher, EgressPublisher egressPublisher, long leadershipTermId, int memberId, long nowNs, long clusterTimestamp) {
        long resultingPosition;
        if (this.responsePublication.availableWindow() > 0L && (resultingPosition = logPublisher.appendSessionOpen(this, leadershipTermId, clusterTimestamp)) > 0L) {
            this.open(resultingPosition);
            this.timeOfLastActivityNs(nowNs);
            this.sendSessionOpenEvent(egressPublisher, leadershipTermId, memberId);
            return true;
        }
        return false;
    }

    int sendSessionOpenEvent(EgressPublisher egressPublisher, long leadershipTermId, int memberId) {
        if (egressPublisher.sendEvent(this, leadershipTermId, memberId, EventCode.OK, "")) {
            this.clearOpenEventPending();
            return 1;
        }
        return 0;
    }

    void lastActivityNs(long timeNs, long correlationId) {
        this.timeOfLastActivityNs = timeNs;
        this.correlationId = correlationId;
    }

    void reject(EventCode code, String responseDetail, DistinctErrorLog errorLog) {
        this.eventCode = code;
        this.responseDetail = responseDetail;
        this.state(State.REJECTED, (String)(Strings.isEmpty((String)responseDetail) ? code.name() : code.name() + ": " + responseDetail));
        if (null != errorLog) {
            errorLog.record((Throwable)((Object)new ClusterEvent(String.valueOf((Object)code) + " " + responseDetail + ", clusterMemberId=" + this.clusterMemberId + ", id=" + this.id)));
        }
    }

    EventCode eventCode() {
        return this.eventCode;
    }

    String responseDetail() {
        return this.responseDetail;
    }

    long correlationId() {
        return this.correlationId;
    }

    long openedLogPosition() {
        return this.openedLogPosition;
    }

    void closedLogPosition(long closedLogPosition) {
        this.closedLogPosition = closedLogPosition;
    }

    long closedLogPosition() {
        return this.closedLogPosition;
    }

    void hasNewLeaderEventPending(boolean flag) {
        this.hasNewLeaderEventPending = flag;
    }

    boolean hasNewLeaderEventPending() {
        return this.hasNewLeaderEventPending;
    }

    boolean hasOpenEventPending() {
        return this.hasOpenEventPending;
    }

    void clearOpenEventPending() {
        this.hasOpenEventPending = false;
    }

    Action action() {
        return this.action;
    }

    void action(Action action) {
        this.action = action;
    }

    void requestInput(Object requestInput) {
        this.requestInput = requestInput;
    }

    Object requestInput() {
        return this.requestInput;
    }

    void linkIngressImage(Header header) {
        if (-1L == this.ingressImageCorrelationId) {
            this.ingressImageCorrelationId = ((Image)header.context()).correlationId();
        }
    }

    void unlinkIngressImage() {
        this.ingressImageCorrelationId = -1L;
    }

    long ingressImageCorrelationId() {
        return this.ingressImageCorrelationId;
    }

    private long addSessionCounter(Aeron aeron, MutableDirectBuffer tempBuffer, int clusterId) {
        tempBuffer.putInt(0, clusterId);
        tempBuffer.putLong(4, this.id);
        int keyLength = 12;
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(12 + labelLength, "cluster-session: ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(12 + labelLength, this.sessionInfo);
        labelLength += tempBuffer.putStringWithoutLengthAscii(12 + labelLength, " - clusterId=");
        labelLength += tempBuffer.putIntAscii(12 + labelLength, clusterId);
        return aeron.asyncAddCounter(241, (DirectBuffer)tempBuffer, 0, 12, (DirectBuffer)tempBuffer, 12, labelLength);
    }

    private static void logStateChange(int memberId, long sessionId, Action action, State oldState, State newState, String reason) {
    }

    static void checkEncodedPrincipalLength(byte[] encodedPrincipal) {
        if (null != encodedPrincipal && encodedPrincipal.length > 4096) {
            throw new ClusterException("encoded principal max length 4096 exceeded: length=" + encodedPrincipal.length);
        }
    }

    public String toString() {
        return "ClusterSession{id=" + this.id + ", clusterMemberId=" + this.clusterMemberId + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + "', sessionInfo='" + this.sessionInfo + "', hasNewLeaderEventPending=" + this.hasNewLeaderEventPending + ", hasOpenEventPending=" + this.hasOpenEventPending + ", correlationId=" + this.correlationId + ", openedLogPosition=" + this.openedLogPosition + ", closedLogPosition=" + this.closedLogPosition + ", timeOfLastActivityNs=" + this.timeOfLastActivityNs + ", ingressImageCorrelationId=" + this.ingressImageCorrelationId + ", responsePublicationId=" + this.responsePublicationId + ", counterRegistrationId=" + this.counterRegistrationId + ", responsePublication=" + String.valueOf(this.responsePublication) + ", counter=" + String.valueOf(this.counter) + ", state=" + String.valueOf((Object)this.state) + ", responseDetail='" + this.responseDetail + "', eventCode=" + String.valueOf((Object)this.eventCode) + ", closeReason=" + String.valueOf((Object)this.closeReason) + ", action=" + String.valueOf((Object)this.action) + ", requestInput=" + String.valueOf(this.requestInput) + "}";
    }

    static enum Action {
        CLIENT,
        BACKUP,
        HEARTBEAT,
        STANDBY_SNAPSHOT;

    }

    static enum State {
        INIT,
        CONNECTING,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        REJECTED,
        OPEN,
        CLOSING,
        INVALID,
        CLOSED;

    }
}

