/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

public enum ClusterTimeUnit {
    MILLIS(0),
    MICROS(1),
    NANOS(2),
    NULL_VAL(Integer.MIN_VALUE);

    private final int value;

    private ClusterTimeUnit(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ClusterTimeUnit get(int value) {
        switch (value) {
            case 0: {
                return MILLIS;
            }
            case 1: {
                return MICROS;
            }
            case 2: {
                return NANOS;
            }
            case -2147483648: {
                return NULL_VAL;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

